/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.lan;

import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.nio.charset.Charset;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.code.MD_CharacterSetCode;
import org.apache.sis.internal.jaxb.lan.Country;
import org.apache.sis.internal.jaxb.lan.LanguageCode;
import org.apache.sis.internal.util.CollectionsExt;

public final class PT_Locale {
    private Locale locale;
    @XmlElement(name="PT_Locale")
    private Wrapper element;

    private PT_Locale() {
    }

    public PT_Locale(Locale locale) {
        this.locale = locale;
    }

    private PT_Locale(Map.Entry<Locale, Charset> entry) {
        this.locale = entry.getKey();
        this.setCharacterSet(entry.getValue());
    }

    public Locale getLocale() {
        if (this.locale == null && this.element != null) {
            this.locale = Country.getLocale(Context.current(), this.element.language, this.element.country, PT_Locale.class);
        }
        return this.locale;
    }

    final Charset getCharacterSet() {
        return this.element != null ? this.element.characterEncoding : null;
    }

    final void setCharacterSet(Charset encoding) {
        this.element = new Wrapper(this.locale, encoding);
    }

    final boolean addInto(Map<Locale, Charset> addTo) {
        Locale locale = this.getLocale();
        Charset encoding = this.getCharacterSet();
        if (locale != null || encoding != null) {
            boolean wasAbsent = encoding == null && !addTo.containsKey(locale);
            return addTo.put(locale, encoding) != encoding | wasAbsent;
        }
        return false;
    }

    public static PT_Locale first(Map<Locale, Charset> locales) {
        Map.Entry<Locale, Charset> first;
        if (locales != null && (first = CollectionsExt.first(locales.entrySet())) != null) {
            return new PT_Locale(first);
        }
        return null;
    }

    public static Set<PT_Locale> wrap(Map<Locale, Charset> locales) {
        return locales != null && !locales.isEmpty() ? new Sequence(locales) : null;
    }

    @XmlType(name="PT_Locale_Type", propOrder={"languageCode", "language", "country", "characterEncoding"})
    private static final class Wrapper {
        LanguageCode language;
        @XmlElement
        Country country;
        @XmlElement(required=true)
        @XmlJavaTypeAdapter(value=MD_CharacterSetCode.class)
        Charset characterEncoding;
        private boolean isLegacyMetadata;

        public Wrapper() {
        }

        Wrapper(Locale locale, Charset encoding) {
            Context context = Context.current();
            this.isLegacyMetadata = Context.isFlagSet(context, 32);
            this.language = LanguageCode.create(context, locale);
            this.country = Country.create(context, locale);
            this.characterEncoding = encoding;
        }

        @XmlElement(name="languageCode", namespace="http://www.isotc211.org/2005/gmd")
        private LanguageCode getLanguageCode() {
            return this.isLegacyMetadata ? this.language : null;
        }

        private void setLanguageCode(LanguageCode newValue) {
            this.language = newValue;
        }

        @XmlElement(name="language", required=true)
        private LanguageCode getLanguage() {
            return this.isLegacyMetadata ? null : this.language;
        }

        private void setLanguage(LanguageCode newValue) {
            this.language = newValue;
        }

        public void beforeMarshal(Marshaller marshaller) {
            if (this.characterEncoding == null) {
                String encoding;
                try {
                    encoding = (String)marshaller.getProperty("jaxb.encoding");
                }
                catch (PropertyException | ClassCastException e) {
                    Context.warningOccured(Context.current(), PT_Locale.class, "beforeMarshal", e, true);
                    return;
                }
                if (encoding != null) {
                    Context context = Context.current();
                    this.characterEncoding = Context.converter(context).toCharset(context, encoding);
                }
            }
        }
    }

    private static final class Sequence
    extends AbstractSet<PT_Locale> {
        final Map<Locale, Charset> locales;

        Sequence(Map<Locale, Charset> locales) {
            this.locales = locales;
        }

        @Override
        public int size() {
            return this.locales.size();
        }

        @Override
        public boolean add(PT_Locale value) {
            return value != null && value.addInto(this.locales);
        }

        @Override
        public Iterator<PT_Locale> iterator() {
            final Iterator<Map.Entry<Locale, Charset>> it = this.locales.entrySet().iterator();
            return new Iterator<PT_Locale>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public PT_Locale next() {
                    return new PT_Locale((Map.Entry)it.next());
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }
    }
}

