/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.metadata.replace.RS_Identifier;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.Citations;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.InternationalString;

@TitleProperty(name="code")
@XmlType(name="MD_Identifier_Type", namespace="http://standards.iso.org/iso/19115/-3/mcc/1.0", propOrder={"authority", "code", "codeSpace", "version", "description"})
@XmlRootElement(name="MD_Identifier", namespace="http://standards.iso.org/iso/19115/-3/mcc/1.0")
@XmlSeeAlso(value={RS_Identifier.class})
public class DefaultIdentifier
extends ISOMetadata
implements Identifier {
    private static final long serialVersionUID = -23375776954553866L;
    private Citation authority;
    private String code;
    private String codeSpace;
    private String version;
    private InternationalString description;

    public DefaultIdentifier() {
    }

    public DefaultIdentifier(String code) {
        this.code = code;
    }

    public DefaultIdentifier(String codeSpace, String code, String version) {
        this.code = code;
        this.codeSpace = codeSpace;
        this.version = version;
    }

    public DefaultIdentifier(Citation authority, String code) {
        this.authority = authority;
        this.code = code;
        this.codeSpace = Citations.toCodeSpace(authority);
    }

    public DefaultIdentifier(Identifier object) {
        super(object);
        if (object != null) {
            this.code = object.getCode();
            this.codeSpace = object.getCodeSpace();
            this.version = object.getVersion();
            this.description = object.getDescription();
            this.authority = object.getAuthority();
        }
    }

    public static DefaultIdentifier castOrCopy(Identifier object) {
        if (object == null || object instanceof DefaultIdentifier) {
            return (DefaultIdentifier)object;
        }
        return new DefaultIdentifier(object);
    }

    @XmlElement(name="authority")
    public Citation getAuthority() {
        return this.authority;
    }

    public void setAuthority(Citation newValue) {
        this.checkWritePermission(this.authority);
        this.authority = newValue;
    }

    @XmlElement(name="code", required=true)
    public String getCode() {
        return this.code;
    }

    public void setCode(String newValue) {
        this.checkWritePermission(this.code);
        this.code = newValue;
    }

    @XmlElement(name="codeSpace")
    public String getCodeSpace() {
        return this.codeSpace;
    }

    public void setCodeSpace(String newValue) {
        this.checkWritePermission(this.codeSpace);
        this.codeSpace = newValue;
    }

    @XmlElement(name="version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String newValue) {
        this.checkWritePermission(this.version);
        this.version = newValue;
    }

    @XmlElement(name="description")
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString newValue) {
        this.checkWritePermission(this.description);
        this.description = newValue;
    }
}

