/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.citation.Responsibility;
import org.opengis.metadata.distribution.DigitalTransferOptions;
import org.opengis.metadata.distribution.Distributor;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.distribution.StandardOrderProcess;

@XmlType(name="MD_Distributor_Type", propOrder={"distributorContact", "distributionOrderProcesses", "distributorFormats", "distributorTransferOptions"})
@XmlRootElement(name="MD_Distributor")
public class DefaultDistributor
extends ISOMetadata
implements Distributor {
    private static final long serialVersionUID = -8819538342342106743L;
    private Responsibility distributorContact;
    private Collection<StandardOrderProcess> distributionOrderProcesses;
    private Collection<Format> distributorFormats;
    private Collection<DigitalTransferOptions> distributorTransferOptions;

    public DefaultDistributor() {
    }

    public DefaultDistributor(Responsibility distributorContact) {
        this.distributorContact = distributorContact;
    }

    public DefaultDistributor(Distributor object) {
        super(object);
        if (object != null) {
            this.distributorContact = object.getDistributorContact();
            this.distributionOrderProcesses = this.copyCollection(object.getDistributionOrderProcesses(), StandardOrderProcess.class);
            this.distributorFormats = this.copyCollection(object.getDistributorFormats(), Format.class);
            this.distributorTransferOptions = this.copyCollection(object.getDistributorTransferOptions(), DigitalTransferOptions.class);
        }
    }

    public static DefaultDistributor castOrCopy(Distributor object) {
        if (object == null || object instanceof DefaultDistributor) {
            return (DefaultDistributor)object;
        }
        return new DefaultDistributor(object);
    }

    @XmlElement(name="distributorContact", required=true)
    public Responsibility getDistributorContact() {
        return this.distributorContact;
    }

    public void setDistributorContact(Responsibility newValue) {
        this.checkWritePermission(this.distributorContact);
        this.distributorContact = newValue;
    }

    @XmlElement(name="distributionOrderProcess")
    public Collection<StandardOrderProcess> getDistributionOrderProcesses() {
        this.distributionOrderProcesses = this.nonNullCollection(this.distributionOrderProcesses, StandardOrderProcess.class);
        return this.distributionOrderProcesses;
    }

    public void setDistributionOrderProcesses(Collection<? extends StandardOrderProcess> newValues) {
        this.distributionOrderProcesses = this.writeCollection(newValues, this.distributionOrderProcesses, StandardOrderProcess.class);
    }

    @XmlElement(name="distributorFormat")
    public Collection<Format> getDistributorFormats() {
        this.distributorFormats = this.nonNullCollection(this.distributorFormats, Format.class);
        return this.distributorFormats;
    }

    public void setDistributorFormats(Collection<? extends Format> newValues) {
        this.distributorFormats = this.writeCollection(newValues, this.distributorFormats, Format.class);
    }

    @XmlElement(name="distributorTransferOptions")
    public Collection<DigitalTransferOptions> getDistributorTransferOptions() {
        this.distributorTransferOptions = this.nonNullCollection(this.distributorTransferOptions, DigitalTransferOptions.class);
        return this.distributorTransferOptions;
    }

    public void setDistributorTransferOptions(Collection<? extends DigitalTransferOptions> newValues) {
        this.distributorTransferOptions = this.writeCollection(newValues, this.distributorTransferOptions, DigitalTransferOptions.class);
    }
}

