/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.metadata.iso.identification.DefaultCoupledResource;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.identification.CoupledResource;
import org.opengis.metadata.identification.DistributedComputingPlatform;
import org.opengis.metadata.identification.OperationMetadata;

final class OperationName
implements OperationMetadata,
Serializable {
    private static final long serialVersionUID = -7958898214063034276L;
    private final String operationName;

    OperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Collection<DistributedComputingPlatform> getDistributedComputingPlatforms() {
        return Collections.emptySet();
    }

    public Collection<OnlineResource> getConnectPoints() {
        return Collections.emptySet();
    }

    public String toString() {
        return Strings.bracket("OperationMetadata", (Object)this.operationName);
    }

    static void resolve(Collection<OperationMetadata> containsOperations, Collection<CoupledResource> coupledResources) {
        HashMap<String, OperationMetadata> byName = new HashMap<String, OperationMetadata>();
        for (OperationMetadata operation : containsOperations) {
            OperationName.add(byName, operation.getOperationName(), operation);
        }
        for (CoupledResource resource : coupledResources) {
            String name;
            OperationMetadata operation;
            if (!(resource instanceof DefaultCoupledResource) || !((operation = resource.getOperation()) instanceof OperationName) || (operation = (OperationMetadata)byName.get(name = operation.getOperationName())) == null && (operation = (OperationMetadata)byName.get(name)) == null) continue;
            ((DefaultCoupledResource)resource).setOperation(operation);
        }
    }

    private static void add(Map<String, OperationMetadata> byName, String name, OperationMetadata operation) {
        boolean exists = byName.containsKey(name);
        OperationMetadata previous = byName.put(name, operation);
        if (previous != operation && (previous != null || exists)) {
            byName.put(name, null);
        }
    }
}

