/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.maintenance;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Iterator;
import java.util.Set;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.metadata.ExcludedSet;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Messages;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.maintenance.ScopeDescription;
import org.opengis.util.InternationalString;

@XmlType(name="MD_ScopeDescription_Type", namespace="http://standards.iso.org/iso/19115/-3/mcc/1.0")
@XmlRootElement(name="MD_ScopeDescription", namespace="http://standards.iso.org/iso/19115/-3/mcc/1.0")
public class DefaultScopeDescription
extends ISOMetadata
implements ScopeDescription {
    private static final long serialVersionUID = -2029119689389845656L;
    private static final byte DATASET = 1;
    private static final byte FEATURES = 2;
    private static final byte ATTRIBUTES = 3;
    private static final byte FEATURE_INSTANCES = 4;
    private static final byte ATTRIBUTE_INSTANCES = 5;
    private static final byte OTHER = 6;
    private static final String[] NAMES = new String[]{"dataset", "features", "attributes", "featureInstances", "attributeInstances", "other"};
    private static final String[] SETTERS = new String[]{"setDataset", "setFeatures", "setAttributes", "setFeatureInstances", "setAttributeInstances", "setOther"};
    private byte property;
    private Object value;

    public DefaultScopeDescription() {
    }

    public DefaultScopeDescription(ScopeDescription object) {
        super(object);
        if (object != null) {
            for (int i = 1; i <= 6; i = (int)((byte)(i + 1))) {
                Set props = null;
                Object value = null;
                switch (i) {
                    case 1: {
                        value = object.getDataset();
                        break;
                    }
                    case 2: {
                        props = object.getFeatures();
                        break;
                    }
                    case 3: {
                        props = object.getAttributes();
                        break;
                    }
                    case 4: {
                        props = object.getFeatureInstances();
                        break;
                    }
                    case 5: {
                        props = object.getAttributeInstances();
                        break;
                    }
                    case 6: {
                        value = object.getOther();
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
                if (props != null) {
                    value = this.copySet(props, CharSequence.class);
                }
                if (value == null) continue;
                this.value = value;
                this.property = (byte)i;
                break;
            }
        }
    }

    public static DefaultScopeDescription castOrCopy(ScopeDescription object) {
        if (object == null || object instanceof DefaultScopeDescription) {
            return (DefaultScopeDescription)object;
        }
        return new DefaultScopeDescription(object);
    }

    private static Set<CharSequence> cast(Object value) {
        assert (!(value instanceof CheckedContainer) || ((CheckedContainer)value).getElementType() == CharSequence.class);
        return (Set)value;
    }

    private Set<CharSequence> getProperty(byte code) {
        Object value = this.value;
        if (value != null) {
            if (this.property == code) {
                return DefaultScopeDescription.cast(value);
            }
            if (!(value instanceof Set) || !((Set)value).isEmpty()) {
                return Semaphores.query(1) ? null : new ExcludedSet(NAMES[code - 1], NAMES[this.property - 1]);
            }
        }
        Set<CharSequence> c = this.nonNullSet(null, CharSequence.class);
        this.property = code;
        this.value = c;
        return c;
    }

    private void setProperty(Set<? extends CharSequence> newValue, byte code) {
        Set<CharSequence> c = null;
        if (this.property == code) {
            c = DefaultScopeDescription.cast(this.value);
        } else {
            if (Containers.isNullOrEmpty(newValue)) {
                return;
            }
            this.warningOnOverwrite(code);
            this.property = code;
        }
        this.value = this.writeSet(newValue, c, CharSequence.class);
    }

    private void warningOnOverwrite(byte code) {
        if (this.value != null && this.property != code) {
            Context.warningOccured(Context.current(), DefaultScopeDescription.class, SETTERS[code - 1], Messages.class, (short)19, NAMES[this.property - 1], NAMES[code - 1]);
        }
    }

    public ScopeCode getLevel() {
        switch (this.property) {
            case 1: {
                return ScopeCode.DATASET;
            }
            case 2: {
                return ScopeCode.FEATURE_TYPE;
            }
            case 3: {
                return ScopeCode.ATTRIBUTE_TYPE;
            }
            case 4: {
                return ScopeCode.FEATURE;
            }
            case 5: {
                return ScopeCode.ATTRIBUTE;
            }
        }
        return null;
    }

    @XmlElement(name="dataset")
    public String getDataset() {
        return this.property == 1 ? (String)this.value : null;
    }

    public void setDataset(String newValue) {
        this.checkWritePermission(this.value);
        if (newValue != null || this.property == 1) {
            this.warningOnOverwrite((byte)1);
            this.property = 1;
            this.value = newValue;
        }
    }

    @XmlElement(name="features")
    public Set<CharSequence> getFeatures() {
        return this.getProperty((byte)2);
    }

    public void setFeatures(Set<? extends CharSequence> newValues) {
        this.setProperty(newValues, (byte)2);
    }

    @XmlElement(name="attributes")
    public Set<CharSequence> getAttributes() {
        return this.getProperty((byte)3);
    }

    public void setAttributes(Set<? extends CharSequence> newValues) {
        this.setProperty(newValues, (byte)3);
    }

    @XmlElement(name="featureInstances")
    public Set<CharSequence> getFeatureInstances() {
        return this.getProperty((byte)4);
    }

    public void setFeatureInstances(Set<? extends CharSequence> newValues) {
        this.setProperty(newValues, (byte)4);
    }

    @XmlElement(name="attributeInstances")
    public Set<CharSequence> getAttributeInstances() {
        return this.getProperty((byte)5);
    }

    public void setAttributeInstances(Set<? extends CharSequence> newValues) {
        this.setProperty(newValues, (byte)5);
    }

    @XmlElement(name="other")
    public InternationalString getOther() {
        return this.property == 6 ? (InternationalString)this.value : null;
    }

    public void setOther(InternationalString newValue) {
        this.checkWritePermission(this.value);
        if (newValue != null || this.property == 6) {
            this.warningOnOverwrite((byte)6);
            this.property = (byte)6;
            this.value = newValue;
        }
    }

    public void setLevelDescription(ScopeCode level, Set<? extends CharSequence> newValues) {
        if (ScopeCode.DATASET.equals(level)) {
            String description = null;
            if (newValues != null) {
                for (CharSequence charSequence : newValues) {
                    if (charSequence == null) continue;
                    description = charSequence.toString();
                    break;
                }
            }
            this.setDataset(description);
        } else if (ScopeCode.FEATURE_TYPE.equals(level)) {
            this.setFeatures(newValues);
        } else if (ScopeCode.ATTRIBUTE_TYPE.equals(level)) {
            this.setAttributes(newValues);
        } else if (ScopeCode.FEATURE.equals(level)) {
            this.setFeatureInstances(newValues);
        } else if (ScopeCode.ATTRIBUTE.equals(level)) {
            this.setAttributeInstances(newValues);
        } else {
            InternationalString description = null;
            if (newValues != null) {
                CharSequence charSequence;
                Iterator<? extends CharSequence> iterator = newValues.iterator();
                while (iterator.hasNext() && (description = Types.toInternationalString(charSequence = iterator.next())) == null) {
                }
            }
            this.setOther(description);
        }
    }
}

