/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.util.Set;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.measure.Angle;
import org.apache.sis.util.ObjectConverter;

public final class AngleConverter
extends SystemConverter<Angle, Double> {
    private static final long serialVersionUID = -5124032874967170238L;
    static final AngleConverter INSTANCE = new AngleConverter();

    public AngleConverter() {
        super(Angle.class, Double.class);
    }

    @Override
    public ObjectConverter<Angle, Double> unique() {
        return INSTANCE;
    }

    @Override
    public ObjectConverter<Double, Angle> inverse() {
        return Inverse.INSTANCE;
    }

    @Override
    public Set<FunctionProperty> properties() {
        return AngleConverter.bijective();
    }

    @Override
    public Double apply(Angle object) {
        return object.degrees();
    }

    public static final class Inverse
    extends SystemConverter<Double, Angle> {
        private static final long serialVersionUID = -1736966474591258159L;
        static final Inverse INSTANCE = new Inverse();

        public Inverse() {
            super(Double.class, Angle.class);
        }

        @Override
        public ObjectConverter<Double, Angle> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<Angle, Double> inverse() {
            return INSTANCE;
        }

        @Override
        public Set<FunctionProperty> properties() {
            return Inverse.bijective();
        }

        @Override
        public Angle apply(Double object) {
            return new Angle(object);
        }
    }
}

