/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.folder;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.sis.internal.system.CommonExecutor;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;

public abstract class ConcurrentCloser<R> {
    public static final ConcurrentCloser<Resource> RESOURCES = new ConcurrentCloser<Resource>(){

        @Override
        protected Callable<?> closer(Resource r) {
            if (r instanceof DataStore) {
                DataStore ds = (DataStore)r;
                return () -> {
                    ds.close();
                    return null;
                };
            }
            return null;
        }
    };

    protected ConcurrentCloser() {
    }

    protected abstract Callable<?> closer(R var1);

    public final void closeAll(Collection<? extends R> resources) throws DataStoreException {
        ExecutorService executor = CommonExecutor.instance();
        Future[] results = new Future[resources.size()];
        int n = 0;
        for (R r : resources) {
            Callable<?> c = this.closer(r);
            if (c == null) continue;
            results[n++] = executor.submit(c);
        }
        Throwable failure = null;
        for (int i = 0; i < n; ++i) {
            try {
                results[i].get();
                continue;
            }
            catch (InterruptedException | ExecutionException ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                if (failure != null) {
                    failure.addSuppressed(cause);
                    continue;
                }
                failure = cause instanceof DataStoreException ? (DataStoreException)cause : new DataStoreException(cause);
            }
        }
        if (failure != null) {
            throw failure;
        }
    }
}

