/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.Flushable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.ChannelData;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.ArgumentChecks;

public class ChannelDataOutput
extends ChannelData
implements Flushable {
    public final WritableByteChannel channel;

    public ChannelDataOutput(String filename, WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        super(filename, channel, buffer);
        this.channel = channel;
        buffer.limit(0);
    }

    public final void ensureBufferAccepts(int n) throws IOException {
        int capacity = this.buffer.capacity();
        assert (n >= 0 && n <= capacity) : n;
        int after = this.buffer.position() + n;
        if (after > this.buffer.limit()) {
            if (after > capacity) {
                int c;
                this.buffer.flip();
                do {
                    if ((c = this.channel.write(this.buffer)) != 0) continue;
                    this.onEmptyTransfer();
                } while ((after -= c) > capacity);
                this.bufferOffset += (long)this.buffer.position();
                this.buffer.compact();
                assert (after >= this.buffer.position());
            }
            this.buffer.limit(after);
        }
    }

    @Override
    public long getStreamPosition() {
        long position = super.getStreamPosition();
        if (this.getBitOffset() != 0) {
            --position;
        }
        return position;
    }

    public final void writeBit(int bit) throws IOException {
        this.writeBits(bit, 1);
    }

    public final void writeBits(long bits, int numBits) throws IOException {
        ArgumentChecks.ensureBetween("numBits", 0, 64, numBits);
        if (numBits != 0) {
            int bitOffset = this.getBitOffset();
            if (bitOffset != 0) {
                long mask;
                bits &= Numerics.bitmask(numBits) - 1L;
                int r = numBits - (8 - bitOffset);
                if (r >= 0) {
                    mask = bits >>> r;
                    bitOffset = 0;
                } else {
                    mask = bits << -r;
                    bitOffset += numBits;
                }
                numBits = r;
                assert ((mask & 0xFFFFFFFFFFFFFF00L) == 0L) : mask;
                int p = this.buffer.position() - 1;
                this.buffer.put(p, (byte)((long)this.buffer.get(p) | mask));
            }
            while (numBits > 0) {
                long part;
                if ((numBits -= 8) >= 0) {
                    part = bits >>> numBits;
                } else {
                    part = bits << -numBits;
                    bitOffset = 8 + numBits;
                }
                this.writeByte((int)part);
            }
            this.setBitOffset(bitOffset);
        }
    }

    public final void writeByte(int value) throws IOException {
        this.ensureBufferAccepts(1);
        this.buffer.put((byte)value);
    }

    public final void writeShort(int value) throws IOException {
        this.ensureBufferAccepts(2);
        this.buffer.putShort((short)value);
    }

    public final void writeChar(int value) throws IOException {
        this.ensureBufferAccepts(2);
        this.buffer.putChar((char)value);
    }

    public final void writeInt(int value) throws IOException {
        this.ensureBufferAccepts(4);
        this.buffer.putInt(value);
    }

    public final void writeLong(long value) throws IOException {
        this.ensureBufferAccepts(8);
        this.buffer.putLong(value);
    }

    public final void writeFloat(float value) throws IOException {
        this.ensureBufferAccepts(4);
        this.buffer.putFloat(value);
    }

    public final void writeDouble(double value) throws IOException {
        this.ensureBufferAccepts(8);
        this.buffer.putDouble(value);
    }

    public final void write(byte[] src) throws IOException {
        this.write(src, 0, src.length);
    }

    public final void writeShorts(short[] src) throws IOException {
        this.writeShorts(src, 0, src.length);
    }

    public final void writeChars(char[] src) throws IOException {
        this.writeChars(src, 0, src.length);
    }

    public final void writeInts(int[] src) throws IOException {
        this.writeInts(src, 0, src.length);
    }

    public final void writeLongs(long[] src) throws IOException {
        this.writeLongs(src, 0, src.length);
    }

    public final void writeFloats(float[] src) throws IOException {
        this.writeFloats(src, 0, src.length);
    }

    public final void writeDoubles(double[] src) throws IOException {
        this.writeDoubles(src, 0, src.length);
    }

    public final void write(byte[] src, int offset, int length) throws IOException {
        if (length != 0) {
            int n;
            do {
                n = Math.min(this.buffer.capacity(), length);
                this.ensureBufferAccepts(n);
                this.buffer.put(src, offset, n);
                offset += n;
            } while ((length -= n) != 0);
        } else {
            this.clearBitOffset();
        }
    }

    public final void writeChars(final char[] src, int offset, int length) throws IOException {
        new ArrayWriter(){
            private CharBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataOutput.this.buffer.asCharBuffer();
                return this.view;
            }

            @Override
            void transfer(int offset, int n) {
                this.view.put(src, offset, n);
            }
        }.writeFully(2, offset, length);
    }

    public final void writeShorts(final short[] src, int offset, int length) throws IOException {
        new ArrayWriter(){
            private ShortBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataOutput.this.buffer.asShortBuffer();
                return this.view;
            }

            @Override
            void transfer(int offset, int length) {
                this.view.put(src, offset, length);
            }
        }.writeFully(2, offset, length);
    }

    public final void writeInts(final int[] src, int offset, int length) throws IOException {
        new ArrayWriter(){
            private IntBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataOutput.this.buffer.asIntBuffer();
                return this.view;
            }

            @Override
            void transfer(int offset, int n) {
                this.view.put(src, offset, n);
            }
        }.writeFully(4, offset, length);
    }

    public final void writeLongs(final long[] src, int offset, int length) throws IOException {
        new ArrayWriter(){
            private LongBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataOutput.this.buffer.asLongBuffer();
                return this.view;
            }

            @Override
            void transfer(int offset, int n) {
                this.view.put(src, offset, n);
            }
        }.writeFully(8, offset, length);
    }

    public final void writeFloats(final float[] src, int offset, int length) throws IOException {
        new ArrayWriter(){
            private FloatBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataOutput.this.buffer.asFloatBuffer();
                return this.view;
            }

            @Override
            void transfer(int offset, int n) {
                this.view.put(src, offset, n);
            }
        }.writeFully(4, offset, length);
    }

    public final void writeDoubles(final double[] src, int offset, int length) throws IOException {
        new ArrayWriter(){
            private DoubleBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataOutput.this.buffer.asDoubleBuffer();
                return this.view;
            }

            @Override
            void transfer(int offset, int n) {
                this.view.put(src, offset, n);
            }
        }.writeFully(8, offset, length);
    }

    private void clear() {
        if (this.buffer.hasArray()) {
            int offset = this.buffer.arrayOffset();
            Arrays.fill(this.buffer.array(), offset + this.buffer.position(), offset + this.buffer.limit(), (byte)0);
        } else {
            while (this.buffer.hasRemaining()) {
                this.buffer.put((byte)0);
            }
        }
    }

    @Override
    public final void seek(long position) throws IOException {
        long p = Math.subtractExact(position, this.bufferOffset);
        if (p >= 0L && p <= (long)this.buffer.limit()) {
            this.buffer.position((int)p);
            this.clearBitOffset();
        } else if (this.channel instanceof SeekableByteChannel) {
            this.flush();
            ((SeekableByteChannel)this.channel).position(Math.addExact(this.channelOffset, position));
            this.bufferOffset = position;
        } else if (p >= 0L) {
            this.flush();
            if ((p -= (long)this.buffer.limit()) <= (long)this.buffer.capacity()) {
                this.buffer.limit((int)p);
                this.clear();
                this.buffer.position((int)p);
            } else {
                this.buffer.clear();
                this.clear();
                do {
                    if (this.channel.write(this.buffer) == 0) {
                        this.onEmptyTransfer();
                    }
                    this.bufferOffset += (long)this.buffer.position();
                    this.buffer.rewind();
                } while ((p -= (long)this.buffer.position()) > (long)this.buffer.capacity());
                this.buffer.limit((int)p).position((int)p);
            }
        } else {
            throw new IOException(Resources.format((short)13, this.filename));
        }
    }

    @Override
    public final void flush() throws IOException {
        this.buffer.rewind();
        this.writeFully();
        this.buffer.limit(0);
        this.clearBitOffset();
    }

    @Override
    final void flushAndSetPosition(int position) throws IOException {
        int limit = this.buffer.limit();
        this.buffer.rewind().limit(position);
        this.writeFully();
        this.buffer.limit(limit);
    }

    private void writeFully() throws IOException {
        int c;
        int n;
        this.bufferOffset += (long)n;
        for (n = this.buffer.remaining(); n != 0; n -= c) {
            c = this.channel.write(this.buffer);
            if (c != 0) continue;
            this.onEmptyTransfer();
        }
        assert (!this.buffer.hasRemaining()) : this.buffer;
    }

    private abstract class ArrayWriter {
        private ArrayWriter() {
        }

        abstract Buffer createView();

        abstract void transfer(int var1, int var2);

        private void skipInBuffer(int nByte) {
            ChannelDataOutput.this.buffer.position(ChannelDataOutput.this.buffer.position() + nByte);
        }

        final void writeFully(int dataSize, int offset, int length) throws IOException {
            ChannelDataOutput.this.clearBitOffset();
            ChannelDataOutput.this.ensureBufferAccepts(Math.min(length * dataSize, ChannelDataOutput.this.buffer.capacity()));
            Buffer view = this.createView();
            int n = Math.min(view.remaining(), length);
            this.transfer(offset, n);
            this.skipInBuffer(n * dataSize);
            while ((length -= n) != 0) {
                ChannelDataOutput.this.ensureBufferAccepts(Math.min(length, view.capacity()) * dataSize);
                view.rewind().limit(ChannelDataOutput.this.buffer.remaining() / dataSize);
                n = view.remaining();
                this.transfer(offset += n, n);
                this.skipInBuffer(n * dataSize);
            }
        }
    }
}

