/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Collection;
import java.util.Collections;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.referencing.CommonCRS;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@XmlTransient
public abstract class GeographicEnvelope
extends AbstractEnvelope
implements GeographicBoundingBox,
Extent {
    protected GeographicEnvelope() {
    }

    public int getDimension() {
        return 2;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return CommonCRS.WGS84.geographic();
    }

    public double getLower(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getSouthBoundLatitude();
            }
            case 1: {
                return this.getWestBoundLongitude();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public double getUpper(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getNorthBoundLatitude();
            }
            case 1: {
                return this.getEastBoundLongitude();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Collection<? extends GeographicExtent> getGeographicElements() {
        return Collections.singleton(this);
    }

    public Boolean getInclusion() {
        return Boolean.TRUE;
    }
}

