/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Comparator;
import java.util.OptionalLong;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.sis.internal.feature.FeatureUtilities;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureQuery;
import org.apache.sis.storage.FeatureSet;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureType;
import org.opengis.filter.Expression;
import org.opengis.filter.Filter;
import org.opengis.filter.SortBy;
import org.opengis.metadata.Metadata;

final class FeatureSubset
extends AbstractFeatureSet {
    private final FeatureSet source;
    private final FeatureQuery query;
    private FeatureType resultType;

    FeatureSubset(FeatureSet source, FeatureQuery query) {
        super(source);
        this.source = source;
        this.query = query;
    }

    @Override
    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder builder = new MetadataBuilder();
        builder.addDefaultMetadata(this, this.listeners);
        builder.addLineage((CharSequence)Resources.formatInternational((short)76));
        builder.addProcessDescription((CharSequence)Resources.formatInternational((short)77, StoreUtilities.getLabel(this.source)));
        builder.addSource(this.source.getMetadata());
        return builder.build();
    }

    @Override
    public synchronized FeatureType getType() throws DataStoreException {
        if (this.resultType == null) {
            FeatureType type = this.source.getType();
            try {
                this.resultType = this.query.expectedType(type);
            }
            catch (IllegalArgumentException e) {
                throw new DataStoreContentException(Resources.forLocale(this.listeners.getLocale()).getString((short)55, type.getName()), e);
            }
        }
        return this.resultType;
    }

    @Override
    public Stream<Feature> features(boolean parallel) throws DataStoreException {
        FeatureQuery.NamedExpression[] projection;
        OptionalLong limit;
        long offset;
        SortBy<Feature> sortBy;
        Stream<Feature> stream = this.source.features(parallel);
        Filter<? super Feature> selection = this.query.getSelection();
        if (selection != null && !selection.equals((Object)Filter.include())) {
            stream = stream.filter((Predicate<Feature>)selection);
        }
        if ((sortBy = this.query.getSortBy()) != null) {
            stream = stream.sorted((Comparator<Feature>)sortBy);
        }
        if ((offset = this.query.getOffset()) > 0L) {
            stream = stream.skip(offset);
        }
        if ((limit = this.query.getLimit()).isPresent()) {
            stream = stream.limit(limit.getAsLong());
        }
        if ((projection = this.query.getStoredProjection()) != null) {
            Expression[] expressions = new Expression[projection.length];
            for (int i = 0; i < expressions.length; ++i) {
                expressions[i] = projection[i].expression;
            }
            FeatureType type = this.getType();
            String[] names = FeatureUtilities.getNames(type.getProperties(false));
            stream = stream.map(t -> {
                Feature f = type.newInstance();
                for (int i = 0; i < expressions.length; ++i) {
                    f.setPropertyValue(names[i], expressions[i].apply(t));
                }
                return f;
            });
        }
        return stream;
    }
}

