/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreListeners;
import org.opengis.feature.FeatureType;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.referencing.operation.TransformException;

abstract class AggregatedFeatureSet
extends AbstractFeatureSet {
    private ImmutableEnvelope envelope;
    private boolean isEnvelopeComputed;

    protected AggregatedFeatureSet(Resource parent) {
        super(parent);
    }

    protected AggregatedFeatureSet(StoreListeners parent) {
        super(parent, false);
    }

    abstract Collection<FeatureSet> dependencies();

    private boolean getEnvelopes(List<Envelope> addTo) throws DataStoreException {
        for (FeatureSet fs : this.dependencies()) {
            if (fs instanceof AggregatedFeatureSet) {
                if (((AggregatedFeatureSet)fs).getEnvelopes(addTo)) continue;
                return false;
            }
            Optional<Envelope> e = fs.getEnvelope();
            if (e.isEmpty()) {
                return false;
            }
            addTo.add(e.get());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Optional<Envelope> getEnvelope() throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (!this.isEnvelopeComputed) {
                ArrayList<Envelope> envelopes = new ArrayList<Envelope>();
                if (this.getEnvelopes(envelopes)) {
                    try {
                        this.envelope = ImmutableEnvelope.castOrCopy((Envelope)Envelopes.union((Envelope[])((Envelope[])envelopes.toArray(Envelope[]::new))));
                    }
                    catch (TransformException e) {
                        this.listeners.warning((Exception)((Object)e));
                    }
                }
                this.isEnvelopeComputed = true;
            }
            return Optional.ofNullable(this.envelope);
        }
    }

    @Override
    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder metadata = new MetadataBuilder();
        metadata.addDefaultMetadata(this, this.listeners);
        for (FeatureSet fs : this.dependencies()) {
            CharSequence[] charSequenceArray;
            FeatureType type = fs.getType();
            Metadata metadata2 = fs.getMetadata();
            if (type == null) {
                charSequenceArray = null;
            } else {
                CharSequence[] charSequenceArray2 = new CharSequence[1];
                charSequenceArray = charSequenceArray2;
                charSequenceArray2[0] = type.getName().toInternationalString();
            }
            metadata.addSource(metadata2, ScopeCode.FEATURE_TYPE, charSequenceArray);
        }
        return metadata.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearCache() {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            this.isEnvelopeComputed = false;
            this.envelope = null;
            super.clearCache();
        }
    }
}

