/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Objects;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.AbstractJTSGenericSurface;
import org.geotoolkit.internal.jaxb.SurfaceBoundaryAdapter;
import org.locationtech.jts.geom.Geometry;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.geometry.primitive.SurfaceInterpolation;
import org.opengis.geometry.primitive.SurfacePatch;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class JTSSurfacePatch
extends AbstractJTSGenericSurface
implements SurfacePatch {
    private Surface surface;
    private SurfaceInterpolation interpolation;
    @XmlElement(name="PolygonPatch", namespace="http://www.opengis.net/gml")
    @XmlJavaTypeAdapter(value=SurfaceBoundaryAdapter.class)
    private SurfaceBoundary boundary;

    public JTSSurfacePatch() {
        this(null, null);
    }

    public JTSSurfacePatch(SurfaceInterpolation interpolation, SurfaceBoundary boundary) {
        this.interpolation = interpolation;
        this.boundary = boundary;
    }

    public Surface getSurface() {
        return null;
    }

    public void setSurface(Surface surface) {
        this.surface = surface;
    }

    public SurfaceInterpolation getInterpolation() {
        return this.interpolation;
    }

    public abstract int getNumDerivativesOnBoundary();

    public SurfaceBoundary getBoundary() {
        return this.boundary;
    }

    @Override
    public final double[] getUpNormal(DirectPosition point) {
        return new double[]{0.0, 0.0, 1.0};
    }

    @Override
    public final double getPerimeter() {
        Geometry jtsGeom = this.getJTSGeometry();
        return jtsGeom.getBoundary().getLength();
    }

    @Override
    public final double getArea() {
        Geometry jtsGeom = this.getJTSGeometry();
        return jtsGeom.getArea();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JTSSurfacePatch) {
            JTSSurfacePatch that = (JTSSurfacePatch)object;
            return Objects.equals(this.boundary, that.boundary) && Objects.equals(this.interpolation, that.interpolation) && Objects.equals(this.surface, that.surface);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.surface != null ? this.surface.hashCode() : 0);
        hash = 31 * hash + (this.interpolation != null ? this.interpolation.hashCode() : 0);
        hash = 31 * hash + (this.boundary != null ? this.boundary.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString()).append('\n');
        if (this.boundary != null) {
            sb.append("boundary:").append(this.boundary).append('\n');
        }
        if (this.interpolation != null) {
            sb.append("interpolation:").append(this.interpolation).append('\n');
        }
        if (this.surface != null) {
            sb.append("surface:").append(this.surface).append('\n');
        }
        return sb.toString();
    }
}

