/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.factory;

import java.awt.RenderingHints;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.sis.util.Classes;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.resources.Errors;

final class SerializedKey
implements Serializable {
    private static final long serialVersionUID = -7330917618436040846L;
    private final Class<?> definer;
    private final String field;

    SerializedKey(RenderingHints.Key key) throws NotSerializableException {
        Field f = Hints.fieldOf(key);
        if (f == null) {
            throw new NotSerializableException(Errors.format((short)191, Classes.getShortClassName((Object)key)));
        }
        this.definer = f.getDeclaringClass();
        this.field = f.getName();
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            return this.definer.getField(this.field).get(null);
        }
        catch (ReflectiveOperationException cause) {
            InvalidClassException e = new InvalidClassException(this.definer.getName(), Errors.format((short)65, this));
            e.initCause(cause);
            throw e;
        }
    }

    public String toString() {
        return this.definer.getCanonicalName() + "." + this.field;
    }
}

