/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal;

import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class Threads
extends AtomicInteger
implements ThreadFactory,
RejectedExecutionHandler {
    public static final ThreadGroup GEOTOOLKIT;
    public static final ThreadGroup RESOURCE_DISPOSERS;
    public static final ThreadGroup WORKERS;
    private static final ExecutorService WORK_EXECUTOR;
    private static final ScheduledExecutorService DISPOSAL_EXECUTOR;
    private final boolean disposer;
    private final boolean daemon;
    private final String prefix;

    private Threads(boolean disposer, boolean daemon, String prefix) {
        this.disposer = disposer;
        this.daemon = daemon;
        this.prefix = prefix;
    }

    public static ThreadFactory createThreadFactory(String prefix) {
        return new Threads(false, false, prefix);
    }

    public static void executeWork(Runnable task) {
        WORK_EXECUTOR.execute(task);
    }

    public static <T> Future<T> submitWork(Callable<T> task) {
        return WORK_EXECUTOR.submit(task);
    }

    public static void executeDisposal(Runnable task, long delay) {
        DISPOSAL_EXECUTOR.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public Thread newThread(Runnable task) {
        String name = this.prefix + this.incrementAndGet();
        Thread thread = new Thread(this.disposer ? RESOURCE_DISPOSERS : WORKERS, task, name);
        thread.setPriority(6);
        thread.setDaemon(this.daemon);
        return thread;
    }

    @Override
    public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
        try {
            executor.getQueue().put(task);
        }
        catch (InterruptedException e) {
            throw new RejectedExecutionException(e);
        }
    }

    public static synchronized void shutdown() {
        WORK_EXECUTOR.shutdown();
        DISPOSAL_EXECUTOR.shutdown();
        ThreadPoolExecutor ex = (ThreadPoolExecutor)((Object)DISPOSAL_EXECUTOR);
        for (Runnable task : ex.getQueue()) {
            if (!ex.remove(task)) continue;
            try {
                task.run();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        try {
            if (!(WORK_EXECUTOR.awaitTermination(8L, TimeUnit.SECONDS) && DISPOSAL_EXECUTOR.awaitTermination(2L, TimeUnit.SECONDS) || WORK_EXECUTOR.isTerminated() && DISPOSAL_EXECUTOR.isTerminated())) {
                System.err.println("NOTE: Some background threads didn't completed.");
            }
        }
        catch (InterruptedException e) {
            System.err.println(e);
        }
    }

    public static Thread[] getNonDaemonThreads() {
        Thread[] threads;
        ThreadGroup parent;
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while ((parent = root.getParent()) != null) {
            root = parent;
        }
        int n = root.activeCount();
        while ((n = root.enumerate(threads = new Thread[n << 1])) == threads.length) {
        }
        int nc = 0;
        for (int i = 0; i < n; ++i) {
            Thread thread = threads[i];
            if (thread.isDaemon()) continue;
            threads[nc++] = thread;
        }
        return Arrays.copyOf(threads, nc);
    }

    static {
        ThreadGroup parent = Thread.currentThread().getThreadGroup();
        try {
            ThreadGroup candidate;
            while ((candidate = parent.getParent()) != null) {
                parent = candidate;
            }
        }
        catch (SecurityException candidate) {
            // empty catch block
        }
        GEOTOOLKIT = new ThreadGroup(parent, "Geotoolkit.org");
        RESOURCE_DISPOSERS = new ThreadGroup(GEOTOOLKIT, "ResourceDisposers");
        RESOURCE_DISPOSERS.setMaxPriority(7);
        WORKERS = new ThreadGroup(GEOTOOLKIT, "Workers");
        Threads handlers = new Threads(false, true, "Pooled thread #");
        int n = Math.max(2, Runtime.getRuntime().availableProcessors());
        ThreadPoolExecutor ex = new ThreadPoolExecutor(2, n, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(1000), handlers, handlers);
        ex.allowCoreThreadTimeOut(true);
        WORK_EXECUTOR = ex;
        DISPOSAL_EXECUTOR = Executors.newScheduledThreadPool(1, new Threads(true, true, "Disposer thread #"));
    }
}

