/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.referencing.factory;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.internal.simple.SimpleCitation;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultContact;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.util.SimpleInternationalString;
import org.geotoolkit.referencing.cs.PredefinedCS;
import org.geotoolkit.referencing.operation.DefiningConversion;
import org.geotoolkit.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.Role;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public final class IGNF
extends GeodeticAuthorityFactory
implements CRSAuthorityFactory {
    private static final Citation AUTHORITY;
    private final ReferencingFactoryContainer factories;
    private final Map<String, Object> crsMap = new TreeMap<String, Object>();
    private final Set<String> codes;

    public IGNF() {
        this.crsMap.put("MILLER", "Miller_Cylindrical");
        this.codes = Collections.unmodifiableSet(this.crsMap.keySet());
        this.factories = new ReferencingFactoryContainer();
    }

    public Citation getVendor() {
        return new SimpleCitation("Geotk");
    }

    public Citation getAuthority() {
        return AUTHORITY;
    }

    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) {
        return type.isAssignableFrom(ProjectedCRS.class) ? this.codes : Collections.emptySet();
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        return new SimpleInternationalString(this.createObject(code).getName().getCode());
    }

    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.createCoordinateReferenceSystem(code);
    }

    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        String key = this.trimNamespace(code).toUpperCase();
        Object value = this.crsMap.get(key);
        if (value == null) {
            throw this.noSuchAuthorityCode(CoordinateReferenceSystem.class, code);
        }
        if (value instanceof CoordinateReferenceSystem) {
            return (CoordinateReferenceSystem)value;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", new NamedIdentifier((Citation)Citations.OGC, (CharSequence)"GRS80"));
        DefaultGeodeticDatum datum = new DefaultGeodeticDatum(properties, CommonCRS.ETRS89.ellipsoid(), CommonCRS.ETRS89.primeMeridian());
        ParameterValueGroup param = this.factories.getMathTransformFactory().getDefaultParameters((String)value);
        param.parameter("semi_major").setValue(6378137);
        param.parameter("semi_minor").setValue(6378137);
        Identifier[] identifiers = new Identifier[]{new NamedIdentifier(AUTHORITY, (CharSequence)"MILLER"), new ImmutableIdentifier((Citation)Citations.EPSG, "EPSG", "310642901"), new ImmutableIdentifier((Citation)Citations.EPSG, "EPSG", "54003")};
        properties.clear();
        properties.put("name", identifiers[0]);
        properties.put("identifiers", identifiers);
        ProjectedCRS crs = this.factories.getCRSFactory().createProjectedCRS(properties, (GeographicCRS)new DefaultGeographicCRS(IdentifiedObjects.getProperties((IdentifiedObject)datum, (String[])new String[0]), (GeodeticDatum)datum, CommonCRS.defaultGeographic().getCoordinateSystem()), (Conversion)new DefiningConversion("Miller", param), (CartesianCS)PredefinedCS.PROJECTED);
        this.crsMap.put(key, crs);
        return crs;
    }

    private NoSuchAuthorityCodeException noSuchAuthorityCode(Class<?> type, String code) {
        InternationalString authority = this.getAuthority().getTitle();
        return new NoSuchAuthorityCodeException(Errors.format((short)120, code, authority, type), authority.toString(), this.trimNamespace(code), code);
    }

    static {
        DefaultResponsibleParty r = new DefaultResponsibleParty(Role.RESOURCE_PROVIDER);
        r.setOrganisationName((InternationalString)new SimpleInternationalString("Institut G\u00e9ographique National"));
        r.setContactInfo((Contact)new DefaultContact((OnlineResource)new DefaultOnlineResource(URI.create("http://www.ign.fr"))));
        DefaultCitation c = new DefaultCitation((CharSequence)"IGNF");
        c.setCitedResponsibleParties(Collections.singleton(r));
        c.setPresentationForms(Collections.singleton(PresentationForm.TABLE_DIGITAL));
        c.transitionTo(ModifiableMetadata.State.FINAL);
        AUTHORITY = c;
    }
}

