/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LEDataOutputStream
extends FilterOutputStream
implements DataOutput {
    private long position = 0L;

    public LEDataOutputStream(OutputStream out) {
        super(out);
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.position;
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        this.out.write(data, offset, length);
        this.position += (long)length;
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        this.write(b ? 1 : 0);
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.out.write(b);
        ++this.position;
    }

    @Override
    public void writeShort(int s) throws IOException {
        this.out.write(s & 0xFF);
        this.out.write(s >>> 8 & 0xFF);
        this.position += 2L;
    }

    public final void writeShorts(short[] values) throws IOException {
        for (short value : values) {
            this.writeShort(value);
        }
    }

    public void writeUnsignedShort(int s) throws IOException {
        this.writeShort(s);
    }

    public final void writeUnsignedShorts(int[] values) throws IOException {
        for (int value : values) {
            this.writeUnsignedShort(value);
        }
    }

    @Override
    public void writeChar(int c) throws IOException {
        this.out.write(c & 0xFF);
        this.out.write(c >>> 8 & 0xFF);
        this.position += 2L;
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.out.write(i & 0xFF);
        this.out.write(i >>> 8 & 0xFF);
        this.out.write(i >>> 16 & 0xFF);
        this.out.write(i >>> 24 & 0xFF);
        this.position += 4L;
    }

    public final void writeInts(int[] values) throws IOException {
        for (int value : values) {
            this.writeInt(value);
        }
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.out.write((int)l & 0xFF);
        this.out.write((int)(l >>> 8) & 0xFF);
        this.out.write((int)(l >>> 16) & 0xFF);
        this.out.write((int)(l >>> 24) & 0xFF);
        this.out.write((int)(l >>> 32) & 0xFF);
        this.out.write((int)(l >>> 40) & 0xFF);
        this.out.write((int)(l >>> 48) & 0xFF);
        this.out.write((int)(l >>> 56) & 0xFF);
        this.position += 8L;
    }

    public final void writeLongs(long[] values) throws IOException {
        for (long value : values) {
            this.writeLong(value);
        }
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeFloats(float[] values) throws IOException {
        for (float value : values) {
            this.writeFloat(value);
        }
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeDoubles(double[] values) throws IOException {
        for (double value : values) {
            this.writeDouble(value);
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            this.out.write((byte)s.charAt(i));
        }
        this.position += (long)s.length();
    }

    @Override
    public void writeChars(String s) throws IOException {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            this.out.write(c & 0xFF);
            this.out.write(c >>> 8 & 0xFF);
        }
        this.position += (long)(s.length() * 2);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        throw new IOException("Not supported");
    }

    public void realign(int padding) throws IOException {
        while (this.position % (long)padding != 0L) {
            this.write(0);
        }
    }
}

