/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.utility.parameter;

import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.metadata.citation.Citation;

public class ExtendedParameterDescriptor<T>
extends DefaultParameterDescriptor<T> {
    private Map<String, Object> userObject;

    public ExtendedParameterDescriptor(ExtendedParameterDescriptor<T> descriptor) {
        super(descriptor);
        this.userObject = descriptor.getUserObject();
    }

    public ExtendedParameterDescriptor(String name, Class<T> valueClass, T[] validValues, T defaultValue, Map<String, Object> userObject) {
        super(ExtendedParameterDescriptor.properties(name, null), 1, 1, valueClass, null, (Object[])validValues, defaultValue);
        this.userObject = userObject;
    }

    public ExtendedParameterDescriptor(String name, CharSequence remarks, Class<T> valueClass, T defaultValue, boolean required, Map<String, Object> userObject) {
        super(ExtendedParameterDescriptor.properties(name, remarks), required ? 1 : 0, 1, valueClass, null, null, defaultValue);
        this.userObject = userObject;
    }

    public ExtendedParameterDescriptor(String name, CharSequence remarks, int minOccurs, int maxOccurs, Class<T> valueClass, T defaultValue, T[] validValues, Map<String, Object> userObject) {
        super(ExtendedParameterDescriptor.properties(name, remarks), minOccurs, maxOccurs, valueClass, null, (Object[])validValues, defaultValue);
        this.userObject = userObject;
    }

    public ExtendedParameterDescriptor(String name, String alias, CharSequence remarks, int minOccurs, int maxOccurs, Class<T> valueClass, T defaultValue, T[] validValues, Map<String, Object> userObject) {
        super(ExtendedParameterDescriptor.properties(name, alias, remarks), minOccurs, maxOccurs, valueClass, null, (Object[])validValues, defaultValue);
        this.userObject = userObject;
    }

    public ExtendedParameterDescriptor(Map<String, ?> properties, Class<T> valueClass, T[] validValues, T defaultValue, Comparable<T> minimum, Comparable<T> maximum, Unit<?> unit, int minOccurs, int maxOccurs, Map<String, Object> userObject) {
        super(properties, minOccurs, maxOccurs, valueClass, ExtendedParameterDescriptor.toRange(valueClass, minimum, maximum, unit), (Object[])validValues, defaultValue);
        this.userObject = userObject;
    }

    public ExtendedParameterDescriptor(Map<String, ?> properties, Class<T> valueClass, T[] validValues, T defaultValue, Comparable<T> minimum, Comparable<T> maximum, Unit<?> unit, boolean required, Map<String, Object> userObject) {
        super(properties, required ? 1 : 0, 1, valueClass, ExtendedParameterDescriptor.toRange(valueClass, minimum, maximum, unit), (Object[])validValues, defaultValue);
        this.userObject = userObject;
    }

    public ExtendedParameterDescriptor(String name, CharSequence remarks, Class<T> valueClass, T[] validValues, T defaultValue, Comparable<T> minimum, Comparable<T> maximum, Unit<?> unit, boolean required, Map<String, Object> userObject) {
        super(ExtendedParameterDescriptor.properties(name, remarks), required ? 1 : 0, 1, valueClass, ExtendedParameterDescriptor.toRange(valueClass, minimum, maximum, unit), (Object[])validValues, defaultValue);
        this.userObject = userObject;
    }

    public ExtendedParameterDescriptor(Citation authority, String name, Class<T> valueClass, T[] validValues, T defaultValue, Comparable<T> minimum, Comparable<T> maximum, Unit<?> unit, boolean required, Map<String, Object> userObject) {
        super(ExtendedParameterDescriptor.properties(name, null), required ? 1 : 0, 1, valueClass, ExtendedParameterDescriptor.toRange(valueClass, minimum, maximum, unit), (Object[])validValues, defaultValue);
        this.userObject = userObject;
    }

    public Map<String, Object> getUserObject() {
        return this.userObject;
    }

    private static Map<String, CharSequence> properties(String name, CharSequence remarks) {
        return ExtendedParameterDescriptor.properties(name, null, remarks);
    }

    private static Map<String, CharSequence> properties(String name, String alias, CharSequence remarks) {
        ArgumentChecks.ensureNonNull((String)"Name", (Object)name);
        HashMap<String, CharSequence> properties = new HashMap<String, CharSequence>(4);
        properties.put("name", name);
        if (alias != null) {
            properties.put("alias", alias);
        }
        if (remarks != null) {
            properties.put("remarks", remarks);
        }
        return properties;
    }

    private static <T> Range<?> toRange(Class<T> valueClass, Comparable<T> minimum, Comparable<T> maximum, Unit<?> unit) {
        if (unit != null && Number.class.isAssignableFrom(valueClass)) {
            return new MeasurementRange(valueClass, (Number)((Object)minimum), true, (Number)((Object)maximum), true, unit);
        }
        if (Comparable.class.isAssignableFrom(valueClass) && (minimum != null || maximum != null)) {
            return new Range(valueClass, minimum, true, maximum, true);
        }
        return null;
    }
}

