/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.aggregate;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.isoonjts.JTSUtils;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.AbstractJTSGeometry;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.JTSGeometry;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSLineString;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSPolygon;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSCurve;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSRing;
import org.geotoolkit.internal.jaxb.PolygonPropertyAdapter;
import org.locationtech.jts.geom.Geometry;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Polygon;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.geometry.primitive.Ring;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@XmlType(name="MultiPolygonType", namespace="http://www.opengis.net/gml")
public class JTSMultiPolygon
extends AbstractJTSGeometry {
    private Set<JTSPolygon> elements = new LinkedHashSet<JTSPolygon>();

    public JTSMultiPolygon() {
    }

    public JTSMultiPolygon(CoordinateReferenceSystem crs) {
        super(crs);
    }

    @Override
    protected Geometry computeJTSPeer() {
        Geometry geom;
        ArrayList<Geometry> childParts = new ArrayList<Geometry>();
        for (Polygon polygon : this.elements) {
            if (polygon instanceof JTSGeometry) {
                JTSGeometry jtsGeom = (JTSGeometry)polygon;
                childParts.add(jtsGeom.getJTSGeometry());
                continue;
            }
            throw new IllegalStateException("Only JTSGeometries are allowed in the JTSMultiPolygon class.");
        }
        if (childParts.size() == 1 && (geom = (Geometry)childParts.get(0)) instanceof org.locationtech.jts.geom.Polygon) {
            return JTSUtils.GEOMETRY_FACTORY.createMultiPolygon(new org.locationtech.jts.geom.Polygon[]{(org.locationtech.jts.geom.Polygon)geom});
        }
        return JTSUtils.GEOMETRY_FACTORY.buildGeometry(childParts);
    }

    public Set<JTSPolygon> getElements() {
        return this.elements;
    }

    @XmlElement(name="polygonMember", namespace="http://www.opengis.net/gml")
    @XmlJavaTypeAdapter(value=PolygonPropertyAdapter.class)
    public void setElements(Set<JTSPolygon> elements) {
        this.elements = elements;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("elements:").append('\n');
        for (Polygon polygon : this.elements) {
            sb.append(polygon).append('\n');
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JTSMultiPolygon && super.equals(object)) {
            JTSMultiPolygon that = (JTSMultiPolygon)object;
            return Objects.equals(this.elements, that.elements);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 41 * hash + (this.elements != null ? this.elements.hashCode() : 0);
        return hash;
    }

    public void applyCRSOnchild() {
        for (JTSPolygon polygon : this.elements) {
            JTSRing exterior = (JTSRing)polygon.getBoundary().getExterior();
            exterior.setCoordinateReferenceSystem(this.getCoordinateReferenceSystem());
            for (Primitive p : exterior.getElements()) {
                if (!(p instanceof JTSCurve)) continue;
                JTSCurve curve = (JTSCurve)p;
                curve.setCoordinateReferenceSystem(this.getCoordinateReferenceSystem());
                for (CurveSegment cv : curve.getSegments()) {
                    if (!(cv instanceof JTSLineString)) continue;
                    JTSLineString line = (JTSLineString)cv;
                    line.setCoordinateReferenceSystem(this.getCoordinateReferenceSystem());
                    PointArray pa = line.getControlPoints();
                    ArrayList<Position> newPositions = new ArrayList<Position>();
                    for (Position pos : pa) {
                        if (!(pos instanceof GeneralDirectPosition)) continue;
                        ((GeneralDirectPosition)pos).setCoordinateReferenceSystem(this.getCoordinateReferenceSystem());
                        newPositions.add(pos);
                    }
                    line.getControlPoints().clear();
                    line.getControlPoints().addAll(newPositions);
                }
            }
            if (polygon.getBoundary().getInteriors() != null) {
                for (Ring ring : polygon.getBoundary().getInteriors()) {
                    ((JTSRing)ring).setCoordinateReferenceSystem(this.getCoordinateReferenceSystem());
                    for (Primitive p : ring.getElements()) {
                        if (!(p instanceof JTSCurve)) continue;
                        JTSCurve curve = (JTSCurve)p;
                        curve.setCoordinateReferenceSystem(this.getCoordinateReferenceSystem());
                        for (CurveSegment cv : curve.getSegments()) {
                            if (!(cv instanceof JTSLineString)) continue;
                            JTSLineString line = (JTSLineString)cv;
                            line.setCoordinateReferenceSystem(this.getCoordinateReferenceSystem());
                            PointArray pa = line.getControlPoints();
                            ArrayList<Position> newPositions = new ArrayList<Position>();
                            for (Position pos : pa) {
                                if (!(pos instanceof GeneralDirectPosition)) continue;
                                ((GeneralDirectPosition)pos).setCoordinateReferenceSystem(this.getCoordinateReferenceSystem());
                                newPositions.add(pos);
                            }
                            line.getControlPoints().clear();
                            line.getControlPoints().addAll(newPositions);
                        }
                    }
                }
            }
            polygon.setCoordinateReferenceSystem(this.getCoordinateReferenceSystem());
        }
    }
}

