/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.CommonCRS;
import org.geotoolkit.geometry.isoonjts.JTSUtils;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.AbstractJTSGeometry;
import org.geotoolkit.geometry.jts.SRIDGenerator;
import org.geotoolkit.internal.jaxb.DirectPositionAdapter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.complex.Composite;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Bearing;
import org.opengis.geometry.primitive.OrientablePrimitive;
import org.opengis.geometry.primitive.PrimitiveBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@XmlType(name="PointType", namespace="http://www.opengis.net/gml")
public class JTSPoint
extends AbstractJTSGeometry
implements org.opengis.geometry.primitive.Point {
    private DirectPosition position;

    public JTSPoint() {
        this(null, (CoordinateReferenceSystem)CommonCRS.WGS84.normalizedGeographic());
    }

    public JTSPoint(DirectPosition position) {
        this(position, position.getCoordinateReferenceSystem());
    }

    public JTSPoint(DirectPosition position, CoordinateReferenceSystem crs) {
        super(crs);
        this.position = position == null ? new GeneralDirectPosition(crs) : position;
    }

    public DirectPosition getDirectPosition() {
        return new GeneralDirectPosition(this.position);
    }

    @XmlElement(name="pos", namespace="http://www.opengis.net/gml")
    @XmlJavaTypeAdapter(value=DirectPositionAdapter.class)
    public void setDirectPosition(DirectPosition position) throws UnsupportedOperationException {
        GeneralDirectPosition copy;
        if (this.isMutable()) {
            CoordinateReferenceSystem myCRS = this.getCoordinateReferenceSystem();
            CoordinateReferenceSystem pointCRS = position.getCoordinateReferenceSystem();
            if (pointCRS == null && position instanceof GeneralDirectPosition) {
                ((GeneralDirectPosition)position).setCoordinateReferenceSystem(myCRS);
                pointCRS = myCRS;
            }
            copy = new GeneralDirectPosition(position);
            if (myCRS != null && pointCRS != null && !myCRS.equals(pointCRS)) {
                try {
                    CoordinateOperationFactory cof = (CoordinateOperationFactory)DefaultFactories.forBuildin(CoordinateOperationFactory.class);
                    CoordinateOperation coordOp = cof.createOperation(pointCRS, myCRS);
                    MathTransform mt = coordOp.getMathTransform();
                    mt.transform(position, (DirectPosition)copy);
                }
                catch (OperationNotFoundException e) {
                    throw new RuntimeException("Unable to find an operation", e);
                }
                catch (FactoryException e) {
                    throw new RuntimeException("Factory exception", e);
                }
                catch (TransformException e) {
                    throw new RuntimeException("Error transforming", e);
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
        this.position = copy;
        this.invalidateCachedJTSPeer();
    }

    public PrimitiveBoundary getBoundary() {
        return (PrimitiveBoundary)super.getBoundary();
    }

    public Bearing getBearing(Position toPoint) {
        throw new UnsupportedOperationException("Bearing calculation is not supported");
    }

    @Override
    protected Geometry computeJTSPeer() {
        Point result = JTSUtils.directPositionToPoint(this.position);
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        if (crs != null) {
            int srid = SRIDGenerator.toSRID(crs, SRIDGenerator.Version.V1);
            result.setSRID(srid);
        }
        return result;
    }

    public Set getContainedPrimitives() {
        return Collections.EMPTY_SET;
    }

    public Set getContainingPrimitives() {
        throw new UnsupportedOperationException();
    }

    public Set getComplexes() {
        throw new UnsupportedOperationException();
    }

    public Composite getComposite() {
        return null;
    }

    public OrientablePrimitive[] getProxy() {
        return null;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JTSPoint && super.equals(obj)) {
            JTSPoint that = (JTSPoint)obj;
            return Objects.equals(this.position, that.position);
        }
        return false;
    }

    @Override
    public String toString() {
        Object s = super.toString();
        s = (String)s + "position:" + this.position + "\n";
        return s;
    }
}

