/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.awt;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.Arrays;
import java.util.logging.Level;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.geotoolkit.geometry.jts.awt.AbstractJTSGeometryJ2D;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class JTSGeometryIterator<T extends Geometry>
implements PathIterator {
    static final AffineTransform2D IDENTITY = new AffineTransform2D(new AffineTransform());
    protected MathTransform transform;
    protected T geometry;

    protected JTSGeometryIterator(MathTransform trs) {
        this(null, trs);
    }

    protected JTSGeometryIterator(T geometry, MathTransform trs) {
        this.transform = trs == null ? IDENTITY : trs;
        this.geometry = geometry;
    }

    public void setGeometry(T geom) {
        this.geometry = geom;
    }

    public void setTransform(MathTransform trs) {
        this.transform = trs == null ? IDENTITY : trs;
        this.reset();
    }

    public MathTransform getTransform() {
        return this.transform;
    }

    public T getGeometry() {
        return this.geometry;
    }

    public abstract void reset();

    protected void safeTransform(float[] in, int offset, float[] out, int outOffset, int nb) {
        try {
            this.transform.transform(in, offset, out, outOffset, nb);
        }
        catch (TransformException ex) {
            AbstractJTSGeometryJ2D.LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            Arrays.fill(out, outOffset, outOffset + nb * 2, Float.NaN);
        }
    }

    protected void safeTransform(double[] in, int offset, float[] out, int outOffset, int nb) {
        try {
            this.transform.transform(in, offset, out, outOffset, nb);
        }
        catch (TransformException ex) {
            AbstractJTSGeometryJ2D.LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            Arrays.fill(out, outOffset, outOffset + nb * 2, Float.NaN);
        }
    }

    protected void safeTransform(double[] in, int offset, double[] out, int outOffset, int nb) {
        try {
            this.transform.transform(in, offset, out, outOffset, nb);
        }
        catch (TransformException ex) {
            AbstractJTSGeometryJ2D.LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            Arrays.fill(out, outOffset, outOffset + nb * 2, Double.NaN);
        }
    }
}

