/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.LazySet;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.j2d.ParameterizedAffine;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.Providers;
import org.apache.sis.internal.referencing.provider.VerticalOffset;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.io.wkt.Parser;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.CoordinateSystemTransform;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.OperationMethodSet;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public class DefaultMathTransformFactory
extends AbstractFactory
implements MathTransformFactory,
Parser {
    private static final double ELLIPSOID_PRECISION = 0.01;
    private static volatile Constructor<? extends Parser> parserConstructor;
    private final Iterable<? extends OperationMethod> methods;
    private final ConcurrentMap<String, OperationMethod> methodsByName;
    private final Map<Class<?>, OperationMethodSet> methodsByType;
    private final ThreadLocal<OperationMethod> lastMethod;
    private final WeakHashSet<MathTransform> pool;
    private final AtomicReference<Parser> parser;
    private DefaultMathTransformFactory oppositeCachingPolicy;

    public DefaultMathTransformFactory() {
        this(new Providers());
    }

    public DefaultMathTransformFactory(Iterable<? extends OperationMethod> methods) {
        ArgumentChecks.ensureNonNull("methods", methods);
        this.methods = methods;
        this.methodsByName = new ConcurrentHashMap<String, OperationMethod>();
        this.methodsByType = new IdentityHashMap();
        this.lastMethod = new ThreadLocal();
        this.pool = new WeakHashSet<MathTransform>(MathTransform.class);
        this.parser = new AtomicReference();
    }

    private DefaultMathTransformFactory(DefaultMathTransformFactory parent) {
        this.methods = parent.methods;
        this.methodsByName = parent.methodsByName;
        this.methodsByType = parent.methodsByType;
        this.lastMethod = new ThreadLocal();
        this.pool = null;
        this.parser = parent.parser;
        this.oppositeCachingPolicy = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMathTransformFactory caching(boolean enabled) {
        if (enabled) {
            return this;
        }
        DefaultMathTransformFactory defaultMathTransformFactory = this;
        synchronized (defaultMathTransformFactory) {
            if (this.oppositeCachingPolicy == null) {
                this.oppositeCachingPolicy = new NoCache(this);
            }
            return this.oppositeCachingPolicy;
        }
    }

    final DefaultMathTransformFactory oppositeCachingPolicy() {
        return this.oppositeCachingPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OperationMethod> getAvailableMethods(Class<? extends SingleOperation> type) {
        OperationMethodSet set;
        ArgumentChecks.ensureNonNull("type", type);
        Object object = this.methodsByType;
        synchronized (object) {
            set = this.methodsByType.get(type);
        }
        if (set == null) {
            OperationMethodSet previous;
            object = this.methods;
            synchronized (object) {
                set = new OperationMethodSet(type, this.methods);
            }
            Map<Class<?>, OperationMethodSet> map = this.methodsByType;
            synchronized (map) {
                previous = this.methodsByType.putIfAbsent(type, set);
            }
            if (previous != null) {
                set = previous;
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationMethod getOperationMethod(String identifier) throws NoSuchIdentifierException {
        identifier = identifier.strip();
        ArgumentChecks.ensureNonEmpty("identifier", identifier);
        OperationMethod method = (OperationMethod)this.methodsByName.get(identifier);
        if (method == null) {
            Iterable<? extends OperationMethod> iterable = this.methods;
            synchronized (iterable) {
                method = CoordinateOperations.getOperationMethod(this.methods, identifier);
            }
            if (method == null) {
                throw new NoSuchIdentifierException(Resources.format((short)50, identifier, "https://sis.apache.org/tables/CoordinateOperationMethods.html"), identifier);
            }
            OperationMethod previous = this.methodsByName.putIfAbsent(identifier.intern(), method);
            if (previous != null) {
                method = previous;
            }
        }
        return method;
    }

    public ParameterValueGroup getDefaultParameters(String method) throws NoSuchIdentifierException {
        return this.getOperationMethod(method).getParameters().createValue();
    }

    @Deprecated(since="0.7")
    public MathTransform createParameterizedTransform(ParameterValueGroup parameters) throws NoSuchIdentifierException, FactoryException {
        return this.createParameterizedTransform(parameters, null);
    }

    public MathTransform createParameterizedTransform(ParameterValueGroup parameters, Context context) throws NoSuchIdentifierException, FactoryException {
        MathTransform transform;
        OperationMethod method = null;
        RuntimeException failure = null;
        try {
            ArgumentChecks.ensureNonNull("parameters", parameters);
            ParameterDescriptorGroup descriptor = parameters.getDescriptor();
            String methodName = descriptor.getName().getCode();
            String methodIdentifier = IdentifiedObjects.toString(IdentifiedObjects.getIdentifier((IdentifiedObject)descriptor, Citations.EPSG));
            if (methodIdentifier == null) {
                methodIdentifier = methodName;
            }
            try {
                method = this.getOperationMethod(methodIdentifier);
            }
            catch (NoSuchIdentifierException exception) {
                if (methodIdentifier.equals(methodName)) {
                    throw exception;
                }
                method = this.getOperationMethod(methodName);
                Logging.recoverableException(AbstractMathTransform.LOGGER, DefaultMathTransformFactory.class, "createParameterizedTransform", exception);
            }
            if (!(method instanceof MathTransformProvider)) {
                throw new NoSuchIdentifierException(Errors.format((short)160, Classes.getClass(method)), methodName);
            }
            try {
                if (context != null) {
                    failure = context.completeParameters(this, method, parameters);
                    parameters = context.parameters;
                    method = context.provider;
                }
                transform = ((MathTransformProvider)method).createMathTransform(this, parameters);
            }
            catch (IllegalArgumentException | IllegalStateException exception) {
                throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
            }
            transform = this.unique(transform);
            method = DefaultOperationMethod.redimension(method, transform.getSourceDimensions(), transform.getTargetDimensions());
            if (context != null) {
                transform = this.swapAndScaleAxes(transform, context);
            }
            this.lastMethod.set(method);
        }
        catch (FactoryException e) {
            try {
                if (failure != null) {
                    e.addSuppressed(failure);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.lastMethod.set(method);
                throw throwable;
            }
        }
        return transform;
    }

    public MathTransform swapAndScaleAxes(MathTransform parameterized, Context context) throws FactoryException {
        int kernelDim;
        int resultDim;
        int numTrailingCoordinates;
        ArgumentChecks.ensureNonNull("parameterized", parameterized);
        ArgumentChecks.ensureNonNull("context", context);
        Matrix swap1 = context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        Matrix swap3 = context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        MathTransform step1 = swap1 != null ? this.createAffineTransform(swap1) : MathTransforms.identity(parameterized.getSourceDimensions());
        MathTransform step3 = swap3 != null ? this.createAffineTransform(swap3) : MathTransforms.identity(parameterized.getTargetDimensions());
        MathTransform step2 = parameterized;
        if (context.provider instanceof VerticalOffset) {
            step2 = VerticalOffset.postCreate(step2, swap3);
        }
        if ((numTrailingCoordinates = (resultDim = step3.getSourceDimensions()) - (kernelDim = step2.getTargetDimensions())) != 0) {
            DefaultMathTransformFactory.ensureDimensionChangeAllowed(parameterized, context, numTrailingCoordinates, resultDim);
            step2 = numTrailingCoordinates > 0 ? this.createPassThroughTransform(0, step2, numTrailingCoordinates) : this.createConcatenatedTransform(step2, this.createAffineTransform(Matrices.createDimensionSelect(kernelDim, ArraysExt.range(0, resultDim))));
        }
        int sourceDim = step1.getTargetDimensions();
        int targetDim = step2.getSourceDimensions();
        int insertCount = targetDim - sourceDim;
        if (insertCount != 0) {
            DefaultMathTransformFactory.ensureDimensionChangeAllowed(parameterized, context, insertCount, targetDim);
            MatrixSIS resize = Matrices.createZero(targetDim + 1, sourceDim + 1);
            for (int j = 0; j < targetDim; ++j) {
                resize.setElement(j, Math.min(j, sourceDim), j < sourceDim ? 1.0 : (--insertCount >= numTrailingCoordinates ? 0.0 : Double.NaN));
            }
            resize.setElement(targetDim, sourceDim, 1.0);
            step1 = this.createConcatenatedTransform(step1, this.createAffineTransform(resize));
        }
        MathTransform mt = this.createConcatenatedTransform(this.createConcatenatedTransform(step1, step2), step3);
        if (parameterized instanceof ParameterizedAffine && !(mt instanceof ParameterizedAffine)) {
            mt = ((ParameterizedAffine)parameterized).newTransform(mt);
        }
        return mt;
    }

    private static void ensureDimensionChangeAllowed(MathTransform parameterized, Context context, int change, int resultDim) throws FactoryException {
        if (Math.abs(change) == 1 && resultDim >= 2 && resultDim <= 3 && (context.getSourceCS() instanceof EllipsoidalCS || context.getTargetCS() instanceof EllipsoidalCS)) {
            return;
        }
        String name = null;
        if (parameterized instanceof Parameterized) {
            name = IdentifiedObjects.getDisplayName((IdentifiedObject)((Parameterized)parameterized).getParameterDescriptors(), null);
        }
        if (name == null) {
            name = Classes.getShortClassName(parameterized);
        }
        StringBuilder b = new StringBuilder();
        CoordinateSystem cs = context.getSourceCS();
        if (cs != null) {
            b.append(cs.getDimension()).append("D \u2192 ");
        }
        b.append("tr(").append(parameterized.getSourceDimensions()).append("D \u2192 ").append(parameterized.getTargetDimensions()).append("D)");
        cs = context.getTargetCS();
        if (cs != null) {
            b.append(" \u2192 ").append(cs.getDimension()).append('D');
        }
        throw new InvalidGeodeticParameterException(Resources.format((short)95, name, b));
    }

    @Deprecated(since="0.7")
    public MathTransform createBaseToDerived(CoordinateReferenceSystem baseCRS, ParameterValueGroup parameters, CoordinateSystem derivedCS) throws NoSuchIdentifierException, FactoryException {
        ArgumentChecks.ensureNonNull("baseCRS", baseCRS);
        ArgumentChecks.ensureNonNull("parameters", parameters);
        ArgumentChecks.ensureNonNull("derivedCS", derivedCS);
        Context context = ReferencingUtilities.createTransformContext(baseCRS, null);
        context.setTarget(derivedCS);
        return this.createParameterizedTransform(parameters, context);
    }

    public MathTransform createCoordinateSystemChange(CoordinateSystem source, CoordinateSystem target, Ellipsoid ellipsoid) throws FactoryException {
        boolean isEllipsoidalSource;
        ArgumentChecks.ensureNonNull("source", source);
        ArgumentChecks.ensureNonNull("target", target);
        this.lastMethod.remove();
        if (ellipsoid != null && (isEllipsoidalSource = source instanceof EllipsoidalCS) != target instanceof EllipsoidalCS && (isEllipsoidalSource ? target : source) instanceof CartesianCS) {
            EllipsoidalCS cs;
            String operation;
            Context context = new Context();
            if (isEllipsoidalSource) {
                operation = "Ellipsoid_To_Geocentric";
                cs = (EllipsoidalCS)source;
                context.setSource((CoordinateSystem)cs);
                context.setTarget(target);
                context.sourceEllipsoid = ellipsoid;
            } else {
                operation = "Geocentric_To_Ellipsoid";
                context.setSource(source);
                cs = (EllipsoidalCS)target;
                context.setTarget((CoordinateSystem)cs);
                context.targetEllipsoid = ellipsoid;
            }
            ParameterValueGroup pg = this.getDefaultParameters(operation);
            if (cs.getDimension() < 3) {
                pg.parameter("dim").setValue(2);
            }
            return this.createParameterizedTransform(pg, context);
        }
        return CoordinateSystemTransform.create(this, source, target, this.lastMethod);
    }

    public MathTransform createAffineTransform(Matrix matrix) throws FactoryException {
        this.lastMethod.remove();
        return this.unique(MathTransforms.linear(matrix));
    }

    public MathTransform createConcatenatedTransform(MathTransform tr1, MathTransform tr2) throws FactoryException {
        MathTransform tr;
        this.lastMethod.remove();
        ArgumentChecks.ensureNonNull("tr1", tr1);
        ArgumentChecks.ensureNonNull("tr2", tr2);
        try {
            tr = ConcatenatedTransform.create(tr1, tr2, this);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
        }
        assert (MathTransforms.isValid(MathTransforms.getSteps(tr))) : tr;
        return this.unique(tr);
    }

    public MathTransform createPassThroughTransform(int firstAffectedCoordinate, MathTransform subTransform, int numTrailingCoordinates) throws FactoryException {
        MathTransform tr;
        this.lastMethod.remove();
        try {
            tr = MathTransforms.passThrough(firstAffectedCoordinate, subTransform, numTrailingCoordinates);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
        }
        return this.unique(tr);
    }

    public MathTransform createFromWKT(String text) throws FactoryException {
        Object object;
        this.lastMethod.remove();
        ArgumentChecks.ensureNonEmpty("text", text);
        Parser p = this.parser.getAndSet(null);
        if (p == null) {
            try {
                Constructor<? extends Parser> c = parserConstructor;
                if (c == null) {
                    c = Class.forName("org.apache.sis.io.wkt.MathTransformParser").asSubclass(Parser.class).getConstructor(MathTransformFactory.class);
                    c.setAccessible(true);
                    parserConstructor = c;
                }
                p = c.newInstance(this);
            }
            catch (ReflectiveOperationException e) {
                throw new FactoryException((Throwable)e);
            }
        }
        try {
            object = p.createFromWKT(text);
        }
        catch (FactoryException e) {
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof ParameterNotFoundException)) continue;
                throw new InvalidGeodeticParameterException(e.getLocalizedMessage(), cause);
            }
            throw e;
        }
        this.parser.set(p);
        return (MathTransform)object;
    }

    private MathTransform unique(MathTransform tr) {
        return this.pool != null ? this.pool.unique(tr) : tr;
    }

    public OperationMethod getLastMethodUsed() {
        return this.lastMethod.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Iterable<? extends OperationMethod> iterable = this.methods;
        synchronized (iterable) {
            this.methodsByName.clear();
            Iterable<? extends OperationMethod> m = this.methods;
            if (m instanceof LazySet) {
                ((LazySet)m).reload();
            }
            if (m instanceof ServiceLoader) {
                ((ServiceLoader)m).reload();
            }
            Map<Class<?>, OperationMethodSet> map = this.methodsByType;
            synchronized (map) {
                for (OperationMethodSet c : this.methodsByType.values()) {
                    c.reset();
                }
            }
            if (this.pool != null) {
                this.pool.clear();
            }
        }
    }

    private static final class NoCache
    extends DefaultMathTransformFactory {
        NoCache(DefaultMathTransformFactory parent) {
            super(parent);
        }

        @Override
        public DefaultMathTransformFactory caching(boolean enabled) {
            return enabled ? this.oppositeCachingPolicy() : this;
        }

        @Override
        public void reload() {
            this.oppositeCachingPolicy().reload();
        }
    }

    public static class Context
    implements Serializable {
        private static final long serialVersionUID = -239563539875674709L;
        private CoordinateSystem sourceCS;
        private CoordinateSystem targetCS;
        private Ellipsoid sourceEllipsoid;
        private Ellipsoid targetEllipsoid;
        private OperationMethod provider;
        private ParameterValueGroup parameters;
        private final Map<String, Boolean> contextualParameters = new HashMap<String, Boolean>();

        public void setSource(CoordinateSystem cs) {
            this.sourceCS = cs;
            this.sourceEllipsoid = null;
        }

        public void setSource(GeodeticCRS crs) {
            if (crs != null) {
                this.sourceCS = crs.getCoordinateSystem();
                this.sourceEllipsoid = crs.getDatum().getEllipsoid();
            } else {
                this.sourceCS = null;
                this.sourceEllipsoid = null;
            }
        }

        public void setTarget(CoordinateSystem cs) {
            this.targetCS = cs;
            this.targetEllipsoid = null;
        }

        public void setTarget(GeodeticCRS crs) {
            if (crs != null) {
                this.targetCS = crs.getCoordinateSystem();
                this.targetEllipsoid = crs.getDatum().getEllipsoid();
            } else {
                this.targetCS = null;
                this.targetEllipsoid = null;
            }
        }

        public CoordinateSystem getSourceCS() {
            return this.sourceCS;
        }

        public Ellipsoid getSourceEllipsoid() {
            return this.sourceEllipsoid;
        }

        public CoordinateSystem getTargetCS() {
            return this.targetCS;
        }

        public Ellipsoid getTargetEllipsoid() {
            return this.targetEllipsoid;
        }

        public Matrix getMatrix(ContextualParameters.MatrixRole role) throws FactoryException {
            CoordinateSystem specified;
            boolean inverse = false;
            switch (role) {
                default: {
                    throw new IllegalArgumentException(Errors.format((short)45, "role", (Object)role));
                }
                case INVERSE_NORMALIZATION: {
                    inverse = true;
                }
                case NORMALIZATION: {
                    specified = this.getSourceCS();
                    break;
                }
                case INVERSE_DENORMALIZATION: {
                    inverse = true;
                }
                case DENORMALIZATION: {
                    inverse = !inverse;
                    specified = this.getTargetCS();
                }
            }
            if (specified == null) {
                return null;
            }
            CoordinateSystem normalized = CoordinateSystems.replaceAxes(specified, AxesConvention.NORMALIZED);
            try {
                if (inverse) {
                    return CoordinateSystems.swapAndScaleAxes(normalized, specified);
                }
                return CoordinateSystems.swapAndScaleAxes(specified, normalized);
            }
            catch (IllegalArgumentException | IncommensurableException cause) {
                throw new InvalidGeodeticParameterException(cause.getLocalizedMessage(), cause);
            }
        }

        public OperationMethod getMethodUsed() {
            if (this.provider != null) {
                return this.provider;
            }
            throw new IllegalStateException(Resources.format((short)70));
        }

        public Map<String, Boolean> getContextualParameters() {
            return this.contextualParameters;
        }

        public ParameterValueGroup getCompletedParameters() {
            if (this.parameters != null) {
                return this.parameters;
            }
            throw new IllegalStateException(Resources.format((short)70));
        }

        private void ensureCompatibleParameters(boolean writable) throws IllegalArgumentException {
            ParameterDescriptorGroup expected = this.provider.getParameters();
            if (this.parameters.getDescriptor() != expected || writable && Parameters.isUnmodifiable(this.parameters)) {
                ParameterValueGroup copy = expected.createValue();
                Parameters.copy(this.parameters, copy);
                this.parameters = copy;
            }
        }

        private ParameterValue<?> getContextualParameter(String name) throws ParameterNotFoundException {
            ParameterValue parameter = this.parameters.parameter(name);
            this.contextualParameters.put(name, Boolean.TRUE);
            return parameter;
        }

        private static double getValue(ParameterValue<?> parameter, Unit<?> unit) {
            return parameter.getValue() != null ? parameter.doubleValue(unit) : Double.NaN;
        }

        private static boolean ensureSet(ParameterValue<?> parameter, double actual, double expected, Unit<?> unit, double tolerance) {
            if (Math.abs(actual - expected) <= tolerance) {
                return false;
            }
            if (Double.isNaN(actual)) {
                parameter.setValue(expected, unit);
                return false;
            }
            return true;
        }

        private RuntimeException setEllipsoid(Ellipsoid ellipsoid, String semiMajor, String semiMinor, boolean inverseFlattening, RuntimeException failure) {
            if (ellipsoid != null) {
                this.ensureCompatibleParameters(true);
                ParameterValue<?> mismatchedParam = null;
                double mismatchedValue = 0.0;
                try {
                    ParameterValue<?> ap = this.getContextualParameter(semiMajor);
                    ParameterValue<?> bp = this.getContextualParameter(semiMinor);
                    Unit unit = ellipsoid.getAxisUnit();
                    double a = Context.getValue(ap, unit);
                    double b = Context.getValue(bp, unit);
                    double tol = Units.METRE.getConverterTo(unit).convert(0.01);
                    if (Context.ensureSet(ap, a, ellipsoid.getSemiMajorAxis(), unit, tol)) {
                        this.contextualParameters.put(semiMajor, Boolean.FALSE);
                        mismatchedParam = ap;
                        mismatchedValue = a;
                    }
                    if (Context.ensureSet(bp, b, ellipsoid.getSemiMinorAxis(), unit, tol)) {
                        this.contextualParameters.put(semiMinor, Boolean.FALSE);
                        mismatchedParam = bp;
                        mismatchedValue = b;
                    }
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    if (failure == null) {
                        failure = e;
                    }
                    failure.addSuppressed(e);
                }
                if (mismatchedParam == null && inverseFlattening && ellipsoid.isIvfDefinitive()) {
                    try {
                        ParameterValue<?> ep = this.getContextualParameter("inverse_flattening");
                        double e = Context.getValue(ep, Units.UNITY);
                        if (Context.ensureSet(ep, e, ellipsoid.getInverseFlattening(), Units.UNITY, 1.0E-10)) {
                            this.contextualParameters.put("inverse_flattening", Boolean.FALSE);
                            mismatchedParam = ep;
                            mismatchedValue = e;
                        }
                    }
                    catch (ParameterNotFoundException e) {
                        Logging.recoverableException(AbstractMathTransform.LOGGER, DefaultMathTransformFactory.class, "createParameterizedTransform", e);
                    }
                }
                if (mismatchedParam != null) {
                    LogRecord record = Resources.forLocale(null).getLogRecord(Level.WARNING, (short)33, ellipsoid.getName().getCode(), mismatchedParam.getDescriptor().getName().getCode(), mismatchedValue);
                    Logging.completeAndLog(AbstractMathTransform.LOGGER, DefaultMathTransformFactory.class, "createParameterizedTransform", record);
                }
            }
            return failure;
        }

        final RuntimeException completeParameters(DefaultMathTransformFactory factory, OperationMethod method, ParameterValueGroup userParams) throws FactoryException, IllegalArgumentException {
            boolean targetOnEllipsoid;
            boolean sourceOnEllipsoid;
            String alt;
            if (method instanceof AbstractProvider && (alt = ((AbstractProvider)method).resolveAmbiguity(this)) != null) {
                method = factory.getOperationMethod(alt);
            }
            this.provider = method;
            this.parameters = userParams;
            if (method instanceof DefaultOperationMethod && method.getClass() != DefaultOperationMethod.class) {
                Integer sourceDim = this.sourceCS != null ? this.sourceCS.getDimension() : method.getSourceDimensions().intValue();
                Integer targetDim = this.targetCS != null ? this.targetCS.getDimension() : method.getTargetDimensions().intValue();
                if (sourceDim != null && targetDim != null && (method = ((DefaultOperationMethod)method).redimension(sourceDim, targetDim)) instanceof MathTransformProvider) {
                    this.provider = method;
                }
            }
            this.ensureCompatibleParameters(false);
            if (this.provider instanceof AbstractProvider) {
                AbstractProvider p = (AbstractProvider)this.provider;
                sourceOnEllipsoid = p.sourceOnEllipsoid;
                targetOnEllipsoid = p.targetOnEllipsoid;
            } else {
                sourceOnEllipsoid = this.getSourceEllipsoid() != null;
                boolean bl = targetOnEllipsoid = this.getTargetEllipsoid() != null;
            }
            if (!(sourceOnEllipsoid | targetOnEllipsoid)) {
                return null;
            }
            if (!targetOnEllipsoid) {
                return this.setEllipsoid(this.getSourceEllipsoid(), "semi_major", "semi_minor", true, null);
            }
            if (!sourceOnEllipsoid) {
                return this.setEllipsoid(this.getTargetEllipsoid(), "semi_major", "semi_minor", true, null);
            }
            RuntimeException failure = null;
            if (this.sourceCS != null) {
                try {
                    this.ensureCompatibleParameters(true);
                    ParameterValue<?> p = this.getContextualParameter("dim");
                    if (p.getValue() == null) {
                        p.setValue(this.sourceCS.getDimension());
                    }
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    failure = e;
                }
            }
            failure = this.setEllipsoid(this.getSourceEllipsoid(), "src_semi_major", "src_semi_minor", false, failure);
            failure = this.setEllipsoid(this.getTargetEllipsoid(), "tgt_semi_major", "tgt_semi_minor", false, failure);
            return failure;
        }

        public String toString() {
            Object[] properties = new Object[]{"sourceCS", this.sourceCS, "sourceEllipsoid", this.sourceEllipsoid, "targetCS", this.targetCS, "targetEllipsoid", this.targetEllipsoid};
            for (int i = 1; i < properties.length; i += 2) {
                IdentifiedObject value = (IdentifiedObject)properties[i];
                if (value == null) continue;
                properties[i] = value.getName();
            }
            String text = Strings.toString(this.getClass(), properties);
            if (!this.contextualParameters.isEmpty()) {
                StringBuilder b = new StringBuilder(text);
                boolean isContextual = true;
                do {
                    boolean first = true;
                    for (Map.Entry<String, Boolean> entry : this.contextualParameters.entrySet()) {
                        if (entry.getValue() != isContextual) continue;
                        if (first) {
                            first = false;
                            b.append(System.lineSeparator()).append(isContextual ? "Contextual parameters" : "Inconsistencies").append(": ");
                        } else {
                            b.append(", ");
                        }
                        b.append(entry.getKey());
                    }
                } while (!(isContextual = !isContextual));
                text = b.toString();
            }
            return text;
        }
    }
}

