/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.RTreeNode;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class SpecializableTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -7379277748632094312L;
    private final MathTransform global;
    private final RTreeNode domains;
    private MathTransform inverse;

    SpecializableTransform(MathTransform global, Map<Envelope, MathTransform> specializations) {
        this.global = global;
        RTreeNode root = null;
        int sourceDim = global.getSourceDimensions();
        int targetDim = global.getTargetDimensions();
        for (Map.Entry<Envelope, MathTransform> entry : specializations.entrySet()) {
            MathTransform tr = entry.getValue();
            ArgumentChecks.ensureDimensionsMatch("specializations", sourceDim, targetDim, tr);
            List<Object> inherited = List.of();
            if (tr instanceof SpecializableTransform) {
                inherited = ((SpecializableTransform)tr).roots();
                tr = ((SpecializableTransform)tr).global;
            }
            SubArea area = new SubArea(entry.getKey(), tr);
            ArgumentChecks.ensureDimensionMatches("envelope", sourceDim, area);
            if (area.isEmpty()) continue;
            if (root == null) {
                root = area;
            } else {
                root.addNode(area);
            }
            for (SubArea subArea : inherited) {
                SubArea e = new SubArea(subArea, subArea.transform);
                e.intersect(area);
                if (e.isEmpty()) continue;
                root.addNode(e);
            }
        }
        this.domains = root != null ? root.finish() : null;
    }

    private List<SubArea> roots() {
        if (this.domains == null) {
            return List.of();
        }
        if (this.domains instanceof SubArea) {
            return List.of((SubArea)this.domains);
        }
        return this.domains.getChildren();
    }

    final MathTransform getSubstitute() {
        return this.domains == null ? this.global : null;
    }

    @Override
    public final int getSourceDimensions() {
        return this.global.getSourceDimensions();
    }

    @Override
    public final int getTargetDimensions() {
        return this.global.getTargetDimensions();
    }

    private SubArea locate(DirectPosition pos) {
        RTreeNode node = RTreeNode.locate(this.domains, pos);
        return node instanceof SubArea ? (SubArea)node : null;
    }

    private MathTransform forDomain(DirectPosition pos) {
        RTreeNode domain = RTreeNode.locate(this.domains, pos);
        return domain instanceof SubArea ? ((SubArea)domain).transform : this.global;
    }

    @Override
    public final DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
        return this.forDomain(ptSrc).transform(ptSrc, ptDst);
    }

    @Override
    public final Matrix derivative(DirectPosition point) throws TransformException {
        return this.forDomain(point).derivative(point);
    }

    @Override
    public final Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        Matrix derivative;
        DirectPositionView.Double pos = new DirectPositionView.Double(srcPts, srcOff, this.global.getSourceDimensions());
        MathTransform tr = this.forDomain(pos);
        if (tr instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)tr).transform(srcPts, srcOff, dstPts, dstOff, derivate);
        }
        Matrix matrix = derivative = derivate ? tr.derivative((DirectPosition)pos) : null;
        if (dstPts != null) {
            tr.transform(srcPts, srcOff, dstPts, dstOff, 1);
        }
        return derivative;
    }

    private void transform(TransformCall transform, DirectPositionView src, int dstOff, int srcInc, int dstInc, int numPts) throws TransformException {
        boolean downard = srcInc < 0;
        SubArea domain = this.locate(src);
        while (numPts > 0) {
            MathTransform tr;
            int srcOff = src.offset;
            if (domain == null) {
                tr = this.global;
                do {
                    src.offset += srcInc;
                } while (--numPts > 0 && (domain = this.locate(src)) == null);
            } else {
                RTreeNode next = domain;
                tr = domain.transform;
                do {
                    src.offset += srcInc;
                } while (--numPts > 0 && (next = SubArea.locate(domain, src)) == domain);
                domain = next instanceof SubArea ? next : null;
            }
            int num = (src.offset - srcOff) / srcInc;
            int dstLow = dstOff;
            dstOff += dstInc * num;
            if (downard) {
                srcOff = src.offset - srcInc;
                dstLow = dstOff - dstInc;
            }
            transform.apply(tr, srcOff, dstLow, num);
        }
    }

    @Override
    public final void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcInc = this.getSourceDimensions();
        int dstInc = this.getTargetDimensions();
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, srcInc, dstOff, dstInc, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * srcInc;
                    srcInc = -srcInc;
                    dstOff += (numPts - 1) * dstInc;
                    dstInc = -dstInc;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcInc);
                    srcOff = 0;
                }
            }
        }
        double[] refPts = srcPts;
        this.transform((tr, src, dst, num) -> tr.transform(refPts, src, dstPts, dst, num), new DirectPositionView.Double(srcPts, srcOff, Math.abs(srcInc)), dstOff, srcInc, dstInc, numPts);
    }

    @Override
    public final void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcInc = this.getSourceDimensions();
        int dstInc = this.getTargetDimensions();
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, srcInc, dstOff, dstInc, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * srcInc;
                    srcInc = -srcInc;
                    dstOff += (numPts - 1) * dstInc;
                    dstInc = -dstInc;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcInc);
                    srcOff = 0;
                }
            }
        }
        float[] refPts = srcPts;
        this.transform((tr, src, dst, num) -> tr.transform(refPts, src, dstPts, dst, num), new DirectPositionView.Float(srcPts, srcOff, Math.abs(srcInc)), dstOff, srcInc, dstInc, numPts);
    }

    @Override
    public final void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcDim = this.getSourceDimensions();
        int dstDim = this.getTargetDimensions();
        this.transform((tr, src, dst, num) -> tr.transform(srcPts, src, dstPts, dst, num), new DirectPositionView.Double(srcPts, srcOff, srcDim), dstOff, srcDim, dstDim, numPts);
    }

    @Override
    public final void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcDim = this.getSourceDimensions();
        int dstDim = this.getTargetDimensions();
        this.transform((tr, src, dst, num) -> tr.transform(srcPts, src, dstPts, dst, num), new DirectPositionView.Float(srcPts, srcOff, srcDim), dstOff, srcDim, dstDim, numPts);
    }

    @Override
    protected final int computeHashCode() {
        return super.computeHashCode() + 7 * this.global.hashCode() ^ Objects.hashCode(this.domains);
    }

    @Override
    public final boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode)) {
            SpecializableTransform other = (SpecializableTransform)object;
            return Utilities.deepEquals(this.global, other.global, mode) && Objects.equals(this.domains, other.domains);
        }
        return false;
    }

    @Override
    protected final String formatTo(Formatter formatter) {
        formatter.newLine();
        formatter.append(this.global);
        RTreeNode.walk(this.domains, node -> {
            if (node instanceof SubArea) {
                ((SubArea)node).format(formatter);
            }
        });
        formatter.setInvalidWKT(SpecializableTransform.class, null);
        return "Specializable_MT";
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            this.inverse = this.createInverse();
        }
        return this.inverse;
    }

    Inverse createInverse() throws NoninvertibleTransformException {
        return new Inverse(this);
    }

    private static final class SubArea
    extends RTreeNode {
        private static final long serialVersionUID = -7668993675003269862L;
        final MathTransform transform;
        MathTransform inverse;

        SubArea(Envelope area, MathTransform transform) {
            super(area);
            this.transform = transform;
        }

        final void createInverseTransform() throws NoninvertibleTransformException {
            this.inverse = this.transform.inverse();
            for (RTreeNode node : this.getChildren()) {
                ((SubArea)node).createInverseTransform();
            }
        }

        final void format(Formatter formatter) {
            formatter.newLine();
            formatter.append(this);
            formatter.newLine();
            formatter.append(this.transform);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.transform.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.transform.equals((Object)((SubArea)obj).transform);
        }
    }

    @FunctionalInterface
    private static interface TransformCall {
        public void apply(MathTransform var1, int var2, int var3, int var4) throws TransformException;
    }

    static class Inverse
    extends AbstractMathTransform.Inverse
    implements Serializable {
        private static final long serialVersionUID = 1060617594604917167L;
        private final SpecializableTransform forward;
        private final MathTransform global;

        Inverse(SpecializableTransform forward) throws NoninvertibleTransformException {
            this.forward = forward;
            this.global = forward.global.inverse();
            for (SubArea domain : forward.roots()) {
                domain.createInverseTransform();
            }
        }

        @Override
        public MathTransform inverse() {
            return this.forward;
        }

        @Override
        public final DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
            double[] source = ptSrc.getCoordinate();
            SubArea domain = this.forward.locate(ptDst = this.global.transform(ptSrc, ptDst));
            if (domain != null) {
                ptDst = domain.inverse.transform((DirectPosition)new DirectPositionView.Double(source), ptDst);
            }
            return ptDst;
        }

        @Override
        public final Matrix derivative(DirectPosition point) throws TransformException {
            return this.transform(point.getCoordinate(), 0, null, 0, true);
        }

        @Override
        public final Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            Matrix derivative;
            int srcInc = this.global.getSourceDimensions();
            int dstInc = this.global.getTargetDimensions();
            if (dstPts == null) {
                dstPts = new double[dstInc];
                dstOff = 0;
            } else if (srcPts == dstPts && srcOff + srcInc > dstOff && srcOff < dstOff + dstInc) {
                srcPts = Arrays.copyOfRange(srcPts, srcOff, srcInc);
                srcOff = 0;
            }
            MathTransform tr = this.global;
            boolean secondTry = false;
            do {
                if (tr instanceof AbstractMathTransform) {
                    derivative = ((AbstractMathTransform)tr).transform(srcPts, srcOff, dstPts, dstOff, derivate);
                } else {
                    tr.transform(srcPts, srcOff, dstPts, dstOff, 1);
                    Matrix matrix = derivative = derivate ? tr.derivative((DirectPosition)new DirectPositionView.Double(srcPts, srcOff, srcInc)) : null;
                }
                if (secondTry) break;
                SubArea domain = this.forward.locate(new DirectPositionView.Double(dstPts, dstOff, dstInc));
                if (domain == null) continue;
                tr = domain.inverse;
                secondTry = true;
            } while (secondTry);
            return derivative;
        }

        private void transform(TransformCall transform, double[] dstPts, int srcOff, int dstOff, int srcInc, int dstInc, int numPts) throws TransformException {
            transform.apply(this.global, srcOff, dstOff, numPts);
            DirectPositionView.Double dst = new DirectPositionView.Double(dstPts, dstOff, dstInc);
            while (numPts > 0) {
                SubArea domain = this.forward.locate(dst);
                if (domain == null) {
                    dst.offset += dstInc;
                    --numPts;
                    continue;
                }
                do {
                    RTreeNode next = domain;
                    int num = (dst.offset - dstOff) / dstInc;
                    srcOff += num * srcInc;
                    dstOff = dst.offset;
                    do {
                        dst.offset += dstInc;
                        if (--numPts > 0) continue;
                        next = null;
                        break;
                    } while ((next = RTreeNode.locate(domain, dst)) == domain);
                    num = (dst.offset - dstOff) / dstInc;
                    transform.apply(domain.inverse, srcOff, dstOff, num);
                    domain = next instanceof SubArea ? next : null;
                    srcOff += srcInc * num;
                    dstOff = dst.offset;
                } while (domain != null);
            }
        }

        @Override
        public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            int srcEnd;
            if (numPts <= 0) {
                return;
            }
            int srcInc = this.global.getSourceDimensions();
            int dstInc = this.global.getTargetDimensions();
            if (srcPts == dstPts && ((srcEnd = srcOff + numPts * srcInc) > dstOff || dstOff + numPts * dstInc > srcOff)) {
                srcPts = Arrays.copyOfRange(srcPts, srcOff, srcEnd);
                srcOff = 0;
            }
            double[] refPts = srcPts;
            this.transform((tr, src, dst, num) -> tr.transform(refPts, src, dstPts, dst, num), dstPts, srcOff, dstOff, srcInc, dstInc, numPts);
        }

        @Override
        public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
            if (numPts <= 0) {
                return;
            }
            int srcInc = this.global.getSourceDimensions();
            int dstInc = this.global.getTargetDimensions();
            double[] buffer = new double[numPts * dstInc];
            this.transform((tr, src, dst, num) -> tr.transform(srcPts, src, buffer, dst, num), buffer, srcOff, 0, srcInc, dstInc, numPts);
            numPts *= dstInc;
            for (int i = 0; i < numPts; ++i) {
                dstPts[dstOff++] = (float)buffer[i];
            }
        }

        @Override
        public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
            if (numPts <= 0) {
                return;
            }
            int srcInc = this.global.getSourceDimensions();
            int dstInc = this.global.getTargetDimensions();
            double[] buffer = new double[numPts * dstInc];
            this.transform((tr, src, dst, num) -> tr.transform(srcPts, src, buffer, dst, num), buffer, srcOff, 0, srcInc, dstInc, numPts);
            numPts *= dstInc;
            for (int i = 0; i < numPts; ++i) {
                dstPts[dstOff++] = (float)buffer[i];
            }
        }

        @Override
        public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            if (numPts <= 0) {
                return;
            }
            int srcInc = this.global.getSourceDimensions();
            int dstInc = this.global.getTargetDimensions();
            this.transform((tr, src, dst, num) -> tr.transform(srcPts, src, dstPts, dst, num), dstPts, srcOff, dstOff, srcInc, dstInc, numPts);
        }
    }
}

