/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.reference;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.temporal.Calendar;
import org.opengis.temporal.CalendarDate;
import org.opengis.temporal.CalendarEra;
import org.opengis.temporal.JulianDate;
import org.opengis.temporal.Period;
import org.opengis.util.InternationalString;

@XmlType(name="TimeCalendarEra_Type", propOrder={"referenceEvent", "referenceDat", "julianRef", "epochOfUse"})
@XmlRootElement(name="TimeCalendarEra")
public class DefaultCalendarEra
extends AbstractIdentifiedObject
implements CalendarEra {
    private static NumberFormat NUMBER_FORMAT;
    private InternationalString referenceEvent;
    private CalendarDate referenceDate;
    private JulianDate julianReference;
    private Period epochOfUse;
    private Collection<Calendar> datingSystem;

    public DefaultCalendarEra(Map<String, ?> properties, CalendarDate referenceDate, JulianDate julianReference, Period epochOfUse) {
        super(properties);
        Object ref = properties.get("referenceEvent");
        ArgumentChecks.ensureNonNull((String)"referenceEvent", ref);
        ArgumentChecks.ensureNonNull((String)"referenceDate", (Object)referenceDate);
        ArgumentChecks.ensureNonNull((String)"julianReference", (Object)julianReference);
        ArgumentChecks.ensureNonNull((String)"epochOfUse", (Object)epochOfUse);
        if (!(ref instanceof InternationalString)) {
            throw new IllegalArgumentException("reference Event must be instance of refernceEvent");
        }
        this.referenceDate = referenceDate;
        this.referenceEvent = (InternationalString)ref;
        this.julianReference = julianReference;
        this.epochOfUse = epochOfUse;
    }

    private DefaultCalendarEra() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
    }

    private DefaultCalendarEra(CalendarEra object) {
        super((IdentifiedObject)object);
        if (object != null) {
            this.referenceEvent = object.getReferenceEvent();
            ArgumentChecks.ensureNonNull((String)"referenceEvent", (Object)this.referenceEvent);
            this.referenceDate = object.getReferenceDate();
            ArgumentChecks.ensureNonNull((String)"referenceDate", (Object)this.referenceDate);
            this.julianReference = object.getJulianReference();
            ArgumentChecks.ensureNonNull((String)"julianReference", (Object)this.julianReference);
            this.epochOfUse = object.getEpochOfUse();
            ArgumentChecks.ensureNonNull((String)"julianReference", (Object)this.julianReference);
            if (object instanceof DefaultCalendarEra) {
                this.datingSystem = ((DefaultCalendarEra)object).getDatingSystem();
            }
        }
    }

    public static DefaultCalendarEra castOrCopy(CalendarEra object) {
        if (object == null || object instanceof DefaultCalendarEra) {
            return (DefaultCalendarEra)object;
        }
        return new DefaultCalendarEra(object);
    }

    @XmlElement(name="referenceEvent", required=true)
    public InternationalString getReferenceEvent() {
        return this.referenceEvent;
    }

    public CalendarDate getReferenceDate() {
        return this.referenceDate;
    }

    @XmlElement(name="referenceDate", required=true)
    private String getReferenceDat() {
        int[] dat = this.referenceDate.getCalendarDate();
        String str = "" + dat[0];
        for (int i = 1; i < dat.length; ++i) {
            str = str + "-";
            if (dat[i] < 10) {
                str = str + "0";
            }
            str = str + dat[i];
        }
        return str;
    }

    public JulianDate getJulianReference() {
        return this.julianReference;
    }

    @XmlElement(name="julianReference", required=true)
    private String getJulianRef() {
        return NUMBER_FORMAT.format(this.julianReference.getCoordinateValue().doubleValue());
    }

    @XmlElement(name="epochOfUse", required=true)
    public Period getEpochOfUse() {
        return this.epochOfUse;
    }

    public Collection<Calendar> getDatingSystem() {
        return this.datingSystem;
    }

    public void setReferenceEvent(InternationalString referenceEvent) {
        ArgumentChecks.ensureNonNull((String)"referenceEvent", (Object)referenceEvent);
        this.referenceEvent = referenceEvent;
    }

    public void setReferenceDate(CalendarDate referenceDate) {
        ArgumentChecks.ensureNonNull((String)"referenceDate", (Object)referenceDate);
        this.referenceDate = referenceDate;
    }

    public void setJulianReference(JulianDate julianReference) {
        ArgumentChecks.ensureNonNull((String)"julianReference", (Object)julianReference);
        this.julianReference = julianReference;
    }

    public void setEpochOfUse(Period epochOfUse) {
        ArgumentChecks.ensureNonNull((String)"epochOfUse", (Object)epochOfUse);
        this.epochOfUse = epochOfUse;
    }

    public void setDatingSystem(Collection<Calendar> newValues) {
        this.datingSystem = newValues;
    }

    public boolean equals(Object object, ComparisonMode mode) {
        if (object instanceof CalendarEra) {
            DefaultCalendarEra that = (DefaultCalendarEra)((Object)object);
            return Objects.equals(this.datingSystem, that.datingSystem) && Objects.equals(this.epochOfUse, that.epochOfUse) && Objects.equals(this.julianReference, that.julianReference) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.referenceDate, that.referenceDate) && Objects.equals(this.referenceEvent, that.referenceEvent);
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("CalendarEra:").append('\n');
        if (this.getName() != null) {
            s.append("name:").append(this.getName().getCode()).append('\n');
        }
        if (this.epochOfUse != null) {
            s.append("epochOfUse:").append(this.epochOfUse).append('\n');
        }
        if (this.referenceEvent != null) {
            s.append("referenceEvent:").append((CharSequence)this.referenceEvent).append('\n');
        }
        if (this.referenceDate != null) {
            s.append("referenceDate:").append(this.referenceDate).append('\n');
        }
        if (this.julianReference != null) {
            s.append("julianReference:").append(this.julianReference).append('\n');
        }
        if (this.datingSystem != null) {
            s.append("datingSystem:").append(this.datingSystem).append('\n');
        }
        return s.toString();
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        NUMBER_FORMAT = new DecimalFormat("#", dfs);
        NUMBER_FORMAT.setMinimumFractionDigits(9);
    }
}

