/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.PrimitiveTypeProperties;
import org.apache.sis.internal.jaxb.gco.ObjectReference;
import org.apache.sis.internal.jaxb.gco.StringAdapter;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;
import org.apache.sis.xml.ReferenceResolver;
import org.apache.sis.xml.XLink;

public abstract class PropertyType<ValueType extends PropertyType<ValueType, BoundType>, BoundType>
extends XmlAdapter<ValueType, BoundType> {
    protected BoundType metadata;
    private Object reference;

    protected PropertyType() {
    }

    protected PropertyType(BoundType value, boolean mayBeNil) {
        Object property;
        this.metadata = value;
        if (mayBeNil && (property = PrimitiveTypeProperties.property(value)) instanceof NilReason) {
            this.reference = property.toString();
            this.metadata = null;
        }
    }

    protected PropertyType(BoundType value) {
        NilReason reason;
        if (value instanceof NilObject && (reason = ((NilObject)value).getNilReason()) != null) {
            this.reference = reason.toString();
            return;
        }
        Class<BoundType> type = this.getBoundType();
        Context context = Context.current();
        ReferenceResolver resolver = Context.resolver(context);
        String id = Context.getObjectID(context, value);
        if (id != null && resolver.canSubstituteByReference((MarshalContext)context, type, value, id)) {
            try {
                XLink link = new XLink();
                link.setHRef(new URI(null, null, id));
                this.reference = new ObjectReference(null, link);
                return;
            }
            catch (URISyntaxException e) {
                Context.warningOccured(context, this.getClass(), "<init>", e, true);
            }
        }
        this.metadata = value;
        if (value instanceof IdentifiedObject) {
            IdentifierMap map = ((IdentifiedObject)value).getIdentifierMap();
            XLink link = map.getSpecialized(IdentifierSpace.XLINK);
            UUID uuid = map.getSpecialized(IdentifierSpace.UUID);
            if (uuid != null || link != null) {
                if (uuid != null) {
                    if (resolver.canSubstituteByReference((MarshalContext)context, type, value, uuid)) {
                        this.metadata = null;
                    } else {
                        uuid = null;
                    }
                }
                if (link != null && resolver.canSubstituteByReference((MarshalContext)context, type, value, link)) {
                    this.metadata = null;
                }
                if (uuid != null || link != null) {
                    this.reference = new ObjectReference(uuid, link);
                }
            }
        }
    }

    private ObjectReference reference(boolean create) {
        Object ref = this.reference;
        if (ref instanceof ObjectReference) {
            return (ObjectReference)ref;
        }
        if (create) {
            ObjectReference newRef = new ObjectReference();
            this.reference = newRef;
            return newRef;
        }
        return null;
    }

    private XLink xlink(boolean create) {
        ObjectReference ref = this.reference(create);
        if (ref == null) {
            return null;
        }
        XLink xlink = ref.xlink;
        if (create && xlink == null) {
            ref.xlink = xlink = new XLink();
            xlink.setType(XLink.Type.SIMPLE);
        }
        return xlink;
    }

    @XmlAttribute(name="nilReason", namespace="http://standards.iso.org/iso/19115/-3/gco/1.0")
    public final String getNilReason() {
        Object ref = this.reference;
        return ref instanceof String ? (String)ref : null;
    }

    public final void setNilReason(String nilReason) {
        if (!(this.reference instanceof ObjectReference)) {
            this.reference = nilReason;
        }
    }

    @XmlAttribute(name="uuidref")
    public final String getUUIDREF() {
        ObjectReference ref = this.reference(false);
        return ref != null ? PropertyType.toString(ref.uuid) : null;
    }

    public final void setUUIDREF(String uuid) throws IllegalArgumentException {
        Context context = Context.current();
        this.reference((boolean)true).uuid = Context.converter(context).toUUID(context, uuid);
    }

    private static String toString(Object text) {
        return text != null ? text.toString() : null;
    }

    private static URI toURI(String uri) throws URISyntaxException {
        Context context = Context.current();
        return Context.converter(context).toURI((MarshalContext)context, uri);
    }

    @XmlSchemaType(name="anyURI")
    @XmlAttribute(name="href", namespace="http://www.w3.org/1999/xlink")
    public final String getHRef() {
        XLink link = this.xlink(false);
        return link != null ? PropertyType.toString(link.getHRef()) : null;
    }

    public final void setHRef(String href) throws URISyntaxException {
        this.xlink(true).setHRef(PropertyType.toURI(href));
    }

    @XmlSchemaType(name="anyURI")
    @XmlAttribute(name="role", namespace="http://www.w3.org/1999/xlink")
    public final String getRole() {
        XLink link = this.xlink(false);
        return link != null ? PropertyType.toString(link.getRole()) : null;
    }

    public final void setRole(String role) throws URISyntaxException {
        this.xlink(true).setRole(PropertyType.toURI(role));
    }

    @XmlSchemaType(name="anyURI")
    @XmlAttribute(name="arcrole", namespace="http://www.w3.org/1999/xlink")
    public final String getArcRole() {
        XLink link = this.xlink(false);
        return link != null ? PropertyType.toString(link.getArcRole()) : null;
    }

    public final void setArcRole(String arcrole) throws URISyntaxException {
        this.xlink(true).setArcRole(PropertyType.toURI(arcrole));
    }

    @XmlAttribute(name="title", namespace="http://www.w3.org/1999/xlink")
    public final String getTitle() {
        XLink link = this.xlink(false);
        return link != null ? StringAdapter.toString((CharSequence)link.getTitle()) : null;
    }

    public final void setTitle(String title) {
        if ((title = Strings.trimOrNull(title)) != null) {
            this.xlink(true).setTitle(new SimpleInternationalString(title));
        }
    }

    @XmlAttribute(name="show", namespace="http://www.w3.org/1999/xlink")
    public final XLink.Show getShow() {
        XLink link = this.xlink(false);
        return link != null ? link.getShow() : null;
    }

    public final void setShow(XLink.Show show) {
        this.xlink(true).setShow(show);
    }

    @XmlAttribute(name="actuate", namespace="http://www.w3.org/1999/xlink")
    public final XLink.Actuate getActuate() {
        XLink link = this.xlink(false);
        return link != null ? link.getActuate() : null;
    }

    public final void setActuate(XLink.Actuate actuate) {
        this.xlink(true).setActuate(actuate);
    }

    protected abstract Class<BoundType> getBoundType();

    protected final boolean accept2014() {
        return FilterByVersion.CURRENT_METADATA.accept();
    }

    protected abstract ValueType wrap(BoundType var1);

    @Override
    public final ValueType marshal(BoundType value) {
        if (value == null) {
            return null;
        }
        return this.wrap(value);
    }

    @Override
    public final BoundType unmarshal(ValueType value) throws URISyntaxException {
        return value != null ? (BoundType)((PropertyType)value).resolve(Context.current()) : null;
    }

    final BoundType resolve(Context context) throws URISyntaxException {
        NilReason nilReason;
        String value;
        ObjectReference ref = this.reference(false);
        if (ref != null) {
            this.metadata = ref.resolve(context, this.getBoundType(), this.metadata);
        }
        if (this.metadata == null && (value = this.getNilReason()) != null && (nilReason = Context.converter(context).toNilReason(context, value)) != null) {
            this.metadata = nilReason.createNilObject(this.getBoundType());
        }
        return this.metadata;
    }

    protected final void incomplete(String missing) throws IllegalArgumentException {
        throw new IllegalArgumentException(Errors.format((short)85, this.getBoundType(), missing));
    }
}

