/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.event.EventContext;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import javax.naming.spi.NamingManager;
import javax.sql.DataSource;
import org.apache.sis.internal.metadata.sql.Dialect;
import org.apache.sis.internal.metadata.sql.LocalDataSource;
import org.apache.sis.internal.metadata.sql.SQLUtilities;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.system.Shutdown;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Messages;

public abstract class Initializer {
    public static final String DATABASE = "SpatialMetadata";
    public static final String JNDI = "jdbc/SpatialMetadata";
    private static Supplier<DataSource> supplier;
    private static DataSource source;
    private static boolean connected;

    protected Initializer() {
    }

    protected abstract void createSchema(Connection var1) throws SQLException;

    protected abstract void dataSourceChanged();

    public static synchronized boolean setDefault(Supplier<DataSource> ds) {
        if (source == null) {
            supplier = ds;
            return true;
        }
        return false;
    }

    public static synchronized DataSource getDataSource() throws Exception {
        if (source == null) {
            if (Initializer.hasJNDI()) {
                try {
                    Context env = (Context)InitialContext.doLookup("java:comp/env");
                    if (env != null) {
                        source = (DataSource)env.lookup(JNDI);
                        if (env instanceof EventContext) {
                            Listener.register((EventContext)env);
                        }
                        return source;
                    }
                }
                catch (NameNotFoundException | NoInitialContextException e) {
                    LogRecord record = Messages.getResources(null).getLogRecord(Level.CONFIG, (short)24, JNDI);
                    Logging.completeAndLog(LocalDataSource.LOGGER, null, null, record);
                }
            }
            if (supplier != null && (source = supplier.get()) != null) {
                supplier = null;
                return source;
            }
            DataSource embedded = null;
            LocalDataSource[] candidates = null;
            boolean isEnvClear = DataDirectory.isUndefined();
            if (isEnvClear) {
                embedded = Initializer.embedded();
            }
            if (embedded == null) {
                candidates = LocalDataSource.create(DATABASE, Dialect.DERBY, Dialect.HSQL);
                if (!isEnvClear && (candidates == null || candidates[0].create)) {
                    embedded = Initializer.embedded();
                }
            }
            if (embedded != null) {
                source = LocalDataSource.wrap(embedded);
            } else if (candidates != null) {
                source = LocalDataSource.findDriver(candidates);
            } else {
                return null;
            }
            supplier = null;
            if (source.isWrapperFor(LocalDataSource.class)) {
                Shutdown.register(() -> {
                    Initializer.shutdown();
                    return null;
                });
            }
            if (source instanceof LocalDataSource) {
                ((LocalDataSource)source).createDatabase();
            }
        }
        return source;
    }

    public static boolean hasJNDI() {
        return NamingManager.hasInitialContextFactoryBuilder() || System.getProperty("java.naming.factory.initial") != null;
    }

    private static DataSource embedded() {
        for (InstallationResources res : DefaultFactories.createServiceLoader(InstallationResources.class)) {
            if (!res.getAuthorities().contains("Embedded")) continue;
            try {
                String[] names = res.getResourceNames("Embedded");
                for (int i = 0; i < names.length; ++i) {
                    Object ds;
                    if (!DATABASE.equals(names[i]) || !((ds = res.getResource("Embedded", i)) instanceof DataSource)) continue;
                    return (DataSource)ds;
                }
            }
            catch (IOException e) {
                Logging.unexpectedException(LocalDataSource.LOGGER, Initializer.class, "getDataSource", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void connected(DatabaseMetaData metadata, Class<?> classe, String method) throws SQLException {
        Class<Initializer> clazz = Initializer.class;
        synchronized (Initializer.class) {
            Level level = connected ? Level.FINE : Level.CONFIG;
            connected = true;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            LogRecord record = Messages.getResources(null).getLogRecord(level, (short)6, SQLUtilities.getSimplifiedURL(metadata));
            Logging.completeAndLog(SystemListener.LOGGER, classe, method, record);
            return;
        }
    }

    public static Object unspecified(Locale locale, boolean asLog) {
        String value;
        short key;
        if (Initializer.hasJNDI()) {
            key = 24;
            value = JNDI;
        } else {
            key = 16;
            value = "SIS_DATA";
        }
        Messages resources = Messages.getResources(locale);
        return asLog ? resources.getLogRecord(Level.WARNING, key, value) : resources.getString(key, value);
    }

    private static synchronized void shutdown() throws ReflectiveOperationException, SQLException {
        DataSource ds = source;
        source = null;
        connected = false;
        ds.unwrap(LocalDataSource.class).shutdown();
    }

    private static final class Listener
    implements ObjectChangeListener,
    Callable<Object> {
        private final EventContext context;

        private Listener(EventContext context) {
            this.context = context;
        }

        static void register(EventContext context) throws NamingException {
            Listener listener = new Listener(context);
            context.addNamingListener(Initializer.JNDI, 0, (NamingListener)listener);
            Shutdown.register(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws NamingException {
            Class<Initializer> clazz = Initializer.class;
            synchronized (Initializer.class) {
                source = null;
                connected = false;
                this.context.removeNamingListener(this);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
        }

        @Override
        public void objectChanged(NamingEvent event) {
            Shutdown.unregister(this);
            try {
                this.call();
            }
            catch (NamingException e) {
                Logging.recoverableException(SystemListener.LOGGER, Listener.class, "objectChanged", e);
            }
            for (Initializer init : DefaultFactories.createServiceLoader(Initializer.class)) {
                init.dataSourceChanged();
            }
        }

        @Override
        public void namingExceptionThrown(NamingExceptionEvent event) {
            Logging.unexpectedException(SystemListener.LOGGER, Listener.class, "namingExceptionThrown", event.getException());
            this.objectChanged(null);
        }
    }
}

