/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.simple;

import java.io.Serializable;
import java.util.Objects;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.collection.Containers;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.InternationalString;

public class SimpleIdentifiedObject
implements IdentifiedObject,
LenientComparable,
Serializable {
    private static final long serialVersionUID = 5297493321524903545L;
    protected Identifier name;

    protected SimpleIdentifiedObject() {
    }

    public SimpleIdentifiedObject(IdentifiedObject object) {
        this.name = object.getName();
    }

    public SimpleIdentifiedObject(Identifier name) {
        this.name = name;
    }

    public Identifier getName() {
        return this.name;
    }

    public final Extent getDomainOfValidity() {
        return null;
    }

    public final InternationalString getScope() {
        return null;
    }

    public final int hashCode() {
        int code = -847315335;
        Identifier name = this.getName();
        if (name != null) {
            code ^= name.hashCode();
        }
        return code;
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object instanceof IdentifiedObject && (mode != ComparisonMode.STRICT || object.getClass() == this.getClass())) {
            if (mode.isIgnoringMetadata()) {
                return true;
            }
            IdentifiedObject that = (IdentifiedObject)object;
            return Objects.equals(this.getName(), that.getName()) && Containers.isNullOrEmpty(that.getIdentifiers()) && Containers.isNullOrEmpty(that.getAlias()) && that.getRemarks() == null;
        }
        return false;
    }

    public String toString() {
        Citation authority;
        String codespace;
        String code;
        Identifier name = this.name;
        if (name != null) {
            code = name.getCode();
            codespace = name.getCodeSpace();
            authority = name.getAuthority();
        } else {
            code = null;
            codespace = null;
            authority = null;
        }
        StringBuilder buffer = new StringBuilder("IdentifiedObject[\"");
        if (codespace != null) {
            buffer.append(codespace).append(':');
        }
        buffer.append(code).append('\"');
        String identifier = Identifiers.getIdentifier(authority, true);
        if (identifier != null) {
            buffer.append(", Id[\"").append(identifier).append("\"]");
        }
        return buffer.append(']').toString();
    }
}

