/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import jakarta.xml.bind.annotation.XmlTransient;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.metadata.Resources;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.util.CheckedArrayList;
import org.apache.sis.internal.util.CheckedHashSet;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.MetadataCopier;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.StateChanger;
import org.apache.sis.metadata.UnmodifiableMetadataException;
import org.apache.sis.util.collection.CodeListSet;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.CodeList;

@XmlTransient
public abstract class ModifiableMetadata
extends AbstractMetadata {
    private static final byte EDITABLE = 0;
    private static final byte STAGED = 1;
    private static final byte FREEZING = 2;
    private static final byte COMPLETABLE = 3;
    private static final byte FINAL = 4;
    private transient byte state;

    protected ModifiableMetadata() {
    }

    public State state() {
        return State.VALUES[this.state];
    }

    public boolean transitionTo(State target) {
        if (target.code < this.state) {
            throw new UnmodifiableMetadataException(Resources.format((short)1));
        }
        if (target.code == this.state || this.state == 2) {
            return false;
        }
        byte result = this.state;
        try {
            this.state = (byte)2;
            StateChanger.applyTo(target, this);
            result = target.code;
        }
        finally {
            this.state = result;
        }
        return true;
    }

    public ModifiableMetadata deepCopy(State target) {
        MetadataCopier copier;
        if (target.isUnmodifiable()) {
            if (this.state >= 4) {
                return this;
            }
            copier = MetadataCopier.forModifiable(this.getStandard());
        } else {
            copier = new MetadataCopier(this.getStandard());
        }
        ModifiableMetadata md = (ModifiableMetadata)copier.copyRecursively(this.getInterface(), this);
        if (target.code > 0) {
            md.transitionTo(target);
        }
        return md;
    }

    protected void checkWritePermission(Object current) throws UnmodifiableMetadataException {
        if (this.state != 3) {
            if (this.state == 4) {
                throw new UnmodifiableMetadataException(Resources.format((short)1));
            }
        } else if (current != null) {
            MetadataStandard standard = current instanceof AbstractMetadata ? ((AbstractMetadata)current).getStandard() : this.getStandard();
            Object c = standard.getTitle(current);
            if (c != null) {
                current = c;
            }
            throw new UnmodifiableMetadataException(Resources.format((short)2, current));
        }
    }

    protected final <E> List<E> writeList(Collection<? extends E> source, List<E> target, Class<E> elementType) throws UnmodifiableMetadataException {
        return (List)this.write(source, target, elementType, Boolean.FALSE);
    }

    protected final <E> Set<E> writeSet(Collection<? extends E> source, Set<E> target, Class<E> elementType) throws UnmodifiableMetadataException {
        return (Set)this.write(source, target, elementType, Boolean.TRUE);
    }

    protected final <E> Collection<E> writeCollection(Collection<? extends E> source, Collection<E> target, Class<E> elementType) throws UnmodifiableMetadataException {
        return this.write(source, target, elementType, null);
    }

    private <E> Collection<E> write(Collection<? extends E> source, Collection<E> target, Class<E> elementType, Boolean useSet) throws UnmodifiableMetadataException {
        if (source != target) {
            if (this.state == 2) {
                assert (useSet != null || this.collectionType(elementType).isInstance(source)) : elementType;
                return source;
            }
            this.checkWritePermission(ImplementationHelper.valueIfDefined(target));
            if (Containers.isNullOrEmpty(source)) {
                target = null;
            } else {
                if (target != null && this.state != 3) {
                    target.clear();
                } else {
                    if (useSet == null) {
                        useSet = this.useSet(elementType);
                    }
                    target = useSet != false ? ModifiableMetadata.createSet(elementType, source) : ModifiableMetadata.createList(elementType, source);
                }
                target.addAll(source);
                if (this.state == 3) {
                    target = useSet != false ? CollectionsExt.unmodifiableOrCopy((Set)target) : CollectionsExt.unmodifiableOrCopy((List)target);
                }
            }
        }
        return target;
    }

    protected final <K, V> Map<K, V> writeMap(Map<? extends K, ? extends V> source, Map<K, V> target, Class<K> keyType) throws UnmodifiableMetadataException {
        if (source != target) {
            if (this.state == 2) {
                return source;
            }
            this.checkWritePermission(target == null || target.isEmpty() ? null : target);
            if (Containers.isNullOrEmpty(source)) {
                target = null;
            } else {
                if (target != null && this.state != 3) {
                    target.clear();
                } else {
                    target = ModifiableMetadata.createMap(keyType, source);
                }
                target.putAll(source);
                if (this.state == 3) {
                    target = CollectionsExt.unmodifiableOrCopy(target);
                }
            }
        }
        return target;
    }

    protected final <E> List<E> copyList(Collection<? extends E> source, Class<E> elementType) {
        if (Containers.isNullOrEmpty(source)) {
            return null;
        }
        List<? extends E> target = ModifiableMetadata.createList(elementType, source);
        target.addAll(source);
        return target;
    }

    protected final <E> Set<E> copySet(Collection<? extends E> source, Class<E> elementType) {
        if (Containers.isNullOrEmpty(source)) {
            return null;
        }
        Set<? extends E> target = ModifiableMetadata.createSet(elementType, source);
        target.addAll(source);
        return target;
    }

    protected final <E> Collection<E> copyCollection(Collection<? extends E> source, Class<E> elementType) {
        if (Containers.isNullOrEmpty(source)) {
            return null;
        }
        Collection<E> target = this.useSet(elementType) ? ModifiableMetadata.createSet(elementType, source) : ModifiableMetadata.createList(elementType, source);
        target.addAll(source);
        return target;
    }

    protected final <K, V> Map<K, V> copyMap(Map<? extends K, ? extends V> source, Class<K> keyType) {
        if (Containers.isNullOrEmpty(source)) {
            return null;
        }
        Map<? extends K, ? extends V> target = ModifiableMetadata.createMap(keyType, source);
        target.putAll(source);
        return target;
    }

    protected final <E> Collection<E> singleton(E value, Class<E> elementType) {
        if (value == null) {
            return null;
        }
        Collection<E> collection = this.useSet(elementType) ? ModifiableMetadata.createSet(elementType, null) : new CheckedArrayList<E>(elementType, 1);
        collection.add(value);
        return collection;
    }

    private static boolean emptyCollectionAsNull() {
        return Semaphores.query(1);
    }

    protected final <E> List<E> nonNullList(List<E> current, Class<E> elementType) {
        if (current != null) {
            return current.isEmpty() && ModifiableMetadata.emptyCollectionAsNull() ? null : current;
        }
        if (ModifiableMetadata.emptyCollectionAsNull()) {
            return null;
        }
        if (this.state < 2) {
            return ModifiableMetadata.createList(elementType, current);
        }
        return Collections.emptyList();
    }

    protected final <E> Set<E> nonNullSet(Set<E> current, Class<E> elementType) {
        if (current != null) {
            return current.isEmpty() && ModifiableMetadata.emptyCollectionAsNull() ? null : current;
        }
        if (ModifiableMetadata.emptyCollectionAsNull()) {
            return null;
        }
        if (this.state < 2) {
            return ModifiableMetadata.createSet(elementType, current);
        }
        return Collections.emptySet();
    }

    protected final <E> Collection<E> nonNullCollection(Collection<E> current, Class<E> elementType) {
        boolean isModifiable;
        if (current != null) {
            assert (this.collectionType(elementType).isInstance(current));
            return current.isEmpty() && ModifiableMetadata.emptyCollectionAsNull() ? null : current;
        }
        if (ModifiableMetadata.emptyCollectionAsNull()) {
            return null;
        }
        boolean bl = isModifiable = this.state < 2;
        if (this.useSet(elementType)) {
            if (isModifiable) {
                return ModifiableMetadata.createSet(elementType, current);
            }
            return Collections.emptySet();
        }
        if (isModifiable) {
            return ModifiableMetadata.createList(elementType, current);
        }
        return Collections.emptyList();
    }

    protected final <K, V> Map<K, V> nonNullMap(Map<K, V> current, Class<K> keyType) {
        if (current != null) {
            return current.isEmpty() && ModifiableMetadata.emptyCollectionAsNull() ? null : current;
        }
        if (ModifiableMetadata.emptyCollectionAsNull()) {
            return null;
        }
        if (this.state < 2) {
            return ModifiableMetadata.createMap(keyType, current);
        }
        return Collections.emptyMap();
    }

    private static <E> List<E> createList(Class<E> elementType, Collection<?> source) {
        if (source == null) {
            return new CheckedArrayList<E>(elementType);
        }
        return new CheckedArrayList<E>(elementType, source.size());
    }

    private static <E> Set<E> createSet(Class<E> elementType, Collection<?> source) {
        if (Enum.class.isAssignableFrom(elementType)) {
            return EnumSet.noneOf(elementType);
        }
        if (CodeList.class.isAssignableFrom(elementType) && Modifier.isFinal(elementType.getModifiers())) {
            return new CodeListSet<E>(elementType);
        }
        return new CheckedHashSet<E>(elementType, source != null ? Containers.hashMapCapacity(source.size()) : 4);
    }

    private static <K, V> Map<K, V> createMap(Class<K> keyType, Map<?, ?> source) {
        if (Enum.class.isAssignableFrom(keyType)) {
            return new EnumMap(keyType);
        }
        return new LinkedHashMap(source != null ? Containers.hashMapCapacity(source.size()) : 4);
    }

    private <E> boolean useSet(Class<E> elementType) {
        Class<Collection<E>> type = this.collectionType(elementType);
        if (Set.class == type) {
            return true;
        }
        if (List.class == type) {
            return false;
        }
        throw new NoSuchElementException(Errors.format((short)163, type));
    }

    protected <E> Class<? extends Collection<E>> collectionType(Class<E> elementType) {
        return CodeList.class.isAssignableFrom(elementType) || Enum.class.isAssignableFrom(elementType) || Charset.class.isAssignableFrom(elementType) || String.class == elementType || Locale.class == elementType || Currency.class == elementType ? Set.class : List.class;
    }

    public static enum State {
        EDITABLE(0),
        COMPLETABLE(3),
        FINAL(4);

        private static final State[] VALUES;
        final byte code;

        private State(byte code) {
            this.code = code;
        }

        final boolean isUnmodifiable() {
            return this.code >= 4;
        }

        static {
            VALUES = new State[5];
            State.VALUES[0] = EDITABLE;
            State.VALUES[1] = EDITABLE;
            State.VALUES[2] = FINAL;
            State.VALUES[3] = COMPLETABLE;
            State.VALUES[4] = FINAL;
        }
    }
}

