/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Event;
import org.opengis.metadata.acquisition.Instrument;
import org.opengis.metadata.acquisition.Objective;
import org.opengis.metadata.acquisition.ObjectiveType;
import org.opengis.metadata.acquisition.PlatformPass;
import org.opengis.metadata.extent.Extent;
import org.opengis.util.InternationalString;

@XmlType(name="MI_Objective_Type", propOrder={"identifiers", "priority", "types", "functions", "extents", "objectiveOccurrences", "pass", "sensingInstruments"})
@XmlRootElement(name="MI_Objective")
public class DefaultObjective
extends ISOMetadata
implements Objective {
    private static final long serialVersionUID = 3312985886806161441L;
    private InternationalString priority;
    private Collection<ObjectiveType> types;
    private Collection<InternationalString> functions;
    private Collection<Extent> extents;
    private Collection<Event> objectiveOccurrences;
    private Collection<PlatformPass> pass;
    private Collection<Instrument> sensingInstruments;

    public DefaultObjective() {
    }

    public DefaultObjective(Objective object) {
        super(object);
        if (object != null) {
            this.identifiers = this.copyCollection(object.getIdentifiers(), Identifier.class);
            this.priority = object.getPriority();
            this.types = this.copyCollection(object.getTypes(), ObjectiveType.class);
            this.functions = this.copyCollection(object.getFunctions(), InternationalString.class);
            this.extents = this.copyCollection(object.getExtents(), Extent.class);
            this.objectiveOccurrences = this.copyCollection(object.getObjectiveOccurrences(), Event.class);
            this.pass = this.copyCollection(object.getPass(), PlatformPass.class);
            this.sensingInstruments = this.copyCollection(object.getSensingInstruments(), Instrument.class);
        }
    }

    public static DefaultObjective castOrCopy(Objective object) {
        if (object == null || object instanceof DefaultObjective) {
            return (DefaultObjective)object;
        }
        return new DefaultObjective(object);
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Collection<Identifier> getIdentifiers() {
        return NonMarshalledAuthority.filterOnMarshalling(super.getIdentifiers());
    }

    public void setIdentifiers(Collection<? extends Identifier> newValues) {
        newValues = NonMarshalledAuthority.setMarshallables(this.identifiers, newValues);
        this.identifiers = this.writeCollection(newValues, this.identifiers, Identifier.class);
    }

    @XmlElement(name="priority")
    public InternationalString getPriority() {
        return this.priority;
    }

    public void setPriority(InternationalString newValue) {
        this.checkWritePermission(this.priority);
        this.priority = newValue;
    }

    @XmlElement(name="type")
    public Collection<ObjectiveType> getTypes() {
        this.types = this.nonNullCollection(this.types, ObjectiveType.class);
        return this.types;
    }

    public void setTypes(Collection<? extends ObjectiveType> newValues) {
        this.types = this.writeCollection(newValues, this.types, ObjectiveType.class);
    }

    @XmlElement(name="function")
    public Collection<InternationalString> getFunctions() {
        this.functions = this.nonNullCollection(this.functions, InternationalString.class);
        return this.functions;
    }

    public void setFunctions(Collection<? extends InternationalString> newValues) {
        this.functions = this.writeCollection(newValues, this.functions, InternationalString.class);
    }

    @XmlElement(name="extent")
    public Collection<Extent> getExtents() {
        this.extents = this.nonNullCollection(this.extents, Extent.class);
        return this.extents;
    }

    public void setExtents(Collection<? extends Extent> newValues) {
        this.extents = this.writeCollection(newValues, this.extents, Extent.class);
    }

    @XmlElement(name="objectiveOccurence", required=true)
    public Collection<Event> getObjectiveOccurrences() {
        this.objectiveOccurrences = this.nonNullCollection(this.objectiveOccurrences, Event.class);
        return this.objectiveOccurrences;
    }

    public void setObjectiveOccurrences(Collection<? extends Event> newValues) {
        this.objectiveOccurrences = this.writeCollection(newValues, this.objectiveOccurrences, Event.class);
    }

    @XmlElement(name="pass")
    public Collection<PlatformPass> getPass() {
        this.pass = this.nonNullCollection(this.pass, PlatformPass.class);
        return this.pass;
    }

    public void setPass(Collection<? extends PlatformPass> newValues) {
        this.pass = this.writeCollection(newValues, this.pass, PlatformPass.class);
    }

    @XmlElement(name="sensingInstrument")
    public Collection<Instrument> getSensingInstruments() {
        this.sensingInstruments = this.nonNullCollection(this.sensingInstruments, Instrument.class);
        return this.sensingInstruments;
    }

    public void setSensingInstruments(Collection<? extends Instrument> newValues) {
        this.sensingInstruments = this.writeCollection(newValues, this.sensingInstruments, Instrument.class);
    }
}

