/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Instrument;
import org.opengis.metadata.acquisition.Platform;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.Responsibility;
import org.opengis.util.InternationalString;

@XmlType(name="MI_Platform_Type", propOrder={"citation", "identifier", "description", "sponsors", "instruments"})
@XmlRootElement(name="MI_Platform")
public class DefaultPlatform
extends ISOMetadata
implements Platform {
    private static final long serialVersionUID = -1607271701134014369L;
    private Citation citation;
    private InternationalString description;
    private Collection<Responsibility> sponsors;
    private Collection<Instrument> instruments;

    public DefaultPlatform() {
    }

    public DefaultPlatform(Platform object) {
        super(object);
        if (object != null) {
            this.citation = object.getCitation();
            this.identifiers = this.singleton(object.getIdentifier(), Identifier.class);
            this.description = object.getDescription();
            this.sponsors = this.copyCollection(object.getSponsors(), Responsibility.class);
            this.instruments = this.copyCollection(object.getInstruments(), Instrument.class);
        }
    }

    public static DefaultPlatform castOrCopy(Platform object) {
        if (object == null || object instanceof DefaultPlatform) {
            return (DefaultPlatform)object;
        }
        return new DefaultPlatform(object);
    }

    @XmlElement(name="citation")
    public Citation getCitation() {
        return this.citation;
    }

    public void setCitation(Citation newValue) {
        this.checkWritePermission(this.citation);
        this.citation = newValue;
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return super.getIdentifier();
    }

    @Override
    public void setIdentifier(Identifier newValue) {
        super.setIdentifier(newValue);
    }

    @XmlElement(name="description", required=true)
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString newValue) {
        this.checkWritePermission(this.description);
        this.description = newValue;
    }

    @XmlElement(name="sponsor")
    public Collection<Responsibility> getSponsors() {
        this.sponsors = this.nonNullCollection(this.sponsors, Responsibility.class);
        return this.sponsors;
    }

    public void setSponsors(Collection<? extends Responsibility> newValues) {
        this.sponsors = this.writeCollection(newValues, this.sponsors, Responsibility.class);
    }

    @XmlElement(name="instrument", required=true)
    public Collection<Instrument> getInstruments() {
        this.instruments = this.nonNullCollection(this.instruments, Instrument.class);
        return this.instruments;
    }

    public void setInstruments(Collection<? extends Instrument> newValues) {
        this.instruments = this.writeCollection(newValues, this.instruments, Instrument.class);
    }
}

