/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.citation.Address;
import org.opengis.util.InternationalString;

@XmlType(name="CI_Address_Type", propOrder={"deliveryPoints", "city", "administrativeArea", "postalCode", "country", "electronicMailAddresses"})
@XmlRootElement(name="CI_Address")
public class DefaultAddress
extends ISOMetadata
implements Address {
    private static final long serialVersionUID = -1709738216789373888L;
    private InternationalString administrativeArea;
    private InternationalString city;
    private InternationalString country;
    private String postalCode;
    private Collection<InternationalString> deliveryPoints;
    private Collection<String> electronicMailAddresses;

    public DefaultAddress() {
    }

    public DefaultAddress(Address object) {
        super(object);
        if (object != null) {
            this.deliveryPoints = this.copyCollection(object.getDeliveryPoints(), InternationalString.class);
            this.city = object.getCity();
            this.administrativeArea = object.getAdministrativeArea();
            this.postalCode = object.getPostalCode();
            this.country = object.getCountry();
            this.electronicMailAddresses = this.copyCollection(object.getElectronicMailAddresses(), String.class);
        }
    }

    public static DefaultAddress castOrCopy(Address object) {
        if (object == null || object instanceof DefaultAddress) {
            return (DefaultAddress)object;
        }
        return new DefaultAddress(object);
    }

    @XmlElement(name="administrativeArea")
    public InternationalString getAdministrativeArea() {
        return this.administrativeArea;
    }

    public void setAdministrativeArea(InternationalString newValue) {
        this.checkWritePermission(this.administrativeArea);
        this.administrativeArea = newValue;
    }

    @XmlElement(name="city")
    public InternationalString getCity() {
        return this.city;
    }

    public void setCity(InternationalString newValue) {
        this.checkWritePermission(this.city);
        this.city = newValue;
    }

    @XmlElement(name="country")
    public InternationalString getCountry() {
        return this.country;
    }

    public void setCountry(InternationalString newValue) {
        this.checkWritePermission(this.country);
        this.country = newValue;
    }

    @XmlElement(name="deliveryPoint")
    public Collection<InternationalString> getDeliveryPoints() {
        this.deliveryPoints = this.nonNullCollection(this.deliveryPoints, InternationalString.class);
        return this.deliveryPoints;
    }

    public void setDeliveryPoints(Collection<? extends InternationalString> newValues) {
        this.deliveryPoints = this.writeCollection(newValues, this.deliveryPoints, InternationalString.class);
    }

    @XmlElement(name="electronicMailAddress")
    public Collection<String> getElectronicMailAddresses() {
        this.electronicMailAddresses = this.nonNullCollection(this.electronicMailAddresses, String.class);
        return this.electronicMailAddresses;
    }

    public void setElectronicMailAddresses(Collection<? extends String> newValues) {
        this.electronicMailAddresses = this.writeCollection(newValues, this.electronicMailAddresses, String.class);
    }

    @XmlElement(name="postalCode")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String newValue) {
        this.checkWritePermission(this.postalCode);
        this.postalCode = newValue;
    }
}

