/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.Individual;
import org.opengis.metadata.citation.Organisation;
import org.opengis.metadata.citation.Party;
import org.opengis.metadata.identification.BrowseGraphic;

@XmlType(name="CI_Organisation_Type", propOrder={"logo", "individual"})
@XmlRootElement(name="CI_Organisation")
public class DefaultOrganisation
extends AbstractParty
implements Organisation {
    private static final long serialVersionUID = 5113656476176154532L;
    private Collection<BrowseGraphic> logo;
    private Collection<Individual> individual;

    public DefaultOrganisation() {
    }

    public DefaultOrganisation(CharSequence name, BrowseGraphic logo, Individual individual, Contact contactInfo) {
        super(name, contactInfo);
        this.logo = this.singleton(logo, BrowseGraphic.class);
        this.individual = this.singleton(individual, Individual.class);
    }

    public DefaultOrganisation(Organisation object) {
        super((Party)object);
        if (object != null) {
            this.logo = this.copyCollection(object.getLogo(), BrowseGraphic.class);
            this.individual = this.copyCollection(object.getIndividual(), Individual.class);
        }
    }

    public static DefaultOrganisation castOrCopy(Organisation object) {
        if (object == null || object instanceof DefaultOrganisation) {
            return (DefaultOrganisation)object;
        }
        return new DefaultOrganisation(object);
    }

    @XmlElement(name="logo")
    public Collection<BrowseGraphic> getLogo() {
        this.logo = this.nonNullCollection(this.logo, BrowseGraphic.class);
        return this.logo;
    }

    public void setLogo(Collection<? extends BrowseGraphic> newValues) {
        this.logo = this.writeCollection(newValues, this.logo, BrowseGraphic.class);
    }

    @XmlElement(name="individual")
    public Collection<Individual> getIndividual() {
        this.individual = this.nonNullCollection(this.individual, Individual.class);
        return this.individual;
    }

    public void setIndividual(Collection<? extends Individual> newValues) {
        this.individual = this.writeCollection(newValues, this.individual, Individual.class);
    }
}

