/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.constraint;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.citation.Responsibility;
import org.opengis.metadata.constraint.Releasability;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Releasability_Type", propOrder={"addressees", "statement", "disseminationConstraints"})
@XmlRootElement(name="MD_Releasability")
public class DefaultReleasability
extends ISOMetadata
implements Releasability {
    private static final long serialVersionUID = 4449531804328254887L;
    private Collection<Responsibility> addressees;
    private InternationalString statement;
    private Collection<Restriction> disseminationConstraints;

    public DefaultReleasability() {
    }

    public DefaultReleasability(Releasability object) {
        super(object);
        if (object != null) {
            this.addressees = this.copyCollection(object.getAddressees(), Responsibility.class);
            this.statement = object.getStatement();
            this.disseminationConstraints = this.copyCollection(object.getDisseminationConstraints(), Restriction.class);
        }
    }

    public static DefaultReleasability castOrCopy(Releasability object) {
        if (object == null || object instanceof DefaultReleasability) {
            return (DefaultReleasability)object;
        }
        return new DefaultReleasability(object);
    }

    @XmlElement(name="addressee")
    public Collection<Responsibility> getAddressees() {
        this.addressees = this.nonNullCollection(this.addressees, Responsibility.class);
        return this.addressees;
    }

    public void setAddressees(Collection<? extends Responsibility> newValues) {
        this.addressees = this.writeCollection(newValues, this.addressees, Responsibility.class);
    }

    @XmlElement(name="statement")
    public InternationalString getStatement() {
        return this.statement;
    }

    public void setStatement(InternationalString newValue) {
        this.checkWritePermission(this.statement);
        this.statement = newValue;
    }

    @XmlElement(name="disseminationConstraints")
    public Collection<Restriction> getDisseminationConstraints() {
        this.disseminationConstraints = this.nonNullCollection(this.disseminationConstraints, Restriction.class);
        return this.disseminationConstraints;
    }

    public void setDisseminationConstraints(Collection<? extends Restriction> newValues) {
        this.disseminationConstraints = this.writeCollection(newValues, this.disseminationConstraints, Restriction.class);
    }
}

