/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.attachment.AttachmentMarshaller;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.function.UnaryOperator;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.validation.Schema;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.UseLegacyMetadata;
import org.apache.sis.xml.OutputFactory;
import org.apache.sis.xml.Pooled;
import org.apache.sis.xml.TransformVersion;
import org.apache.sis.xml.TransformingWriter;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

final class PooledMarshaller
extends Pooled
implements Marshaller {
    private final Marshaller marshaller;
    private int specificBitMasks;

    PooledMarshaller(Marshaller marshaller, Pooled template) throws JAXBException {
        super(template);
        this.marshaller = marshaller;
        this.initialize(template);
    }

    @Override
    protected void reset(Object key, Object value) throws JAXBException {
        if (key instanceof String) {
            String k = (String)key;
            if (value == null && (k.endsWith(".xmlHeaders") || k.equals("jaxb.schemaLocation"))) {
                value = "";
            }
            this.marshaller.setProperty(k, value);
        } else if (key == AttachmentMarshaller.class) {
            this.marshaller.setAttachmentMarshaller((AttachmentMarshaller)value);
        } else if (key == Schema.class) {
            this.marshaller.setSchema((Schema)value);
        } else if (key == Marshaller.Listener.class) {
            this.marshaller.setListener((Marshaller.Listener)value);
        } else if (key == ValidationEventHandler.class) {
            this.marshaller.setEventHandler((ValidationEventHandler)value);
        } else {
            this.marshaller.setAdapter((Class)key, (XmlAdapter)value);
        }
    }

    private String getEncoding() throws PropertyException {
        return (String)this.marshaller.getProperty("jaxb.encoding");
    }

    @Override
    final int specificBitMasks() {
        return this.specificBitMasks;
    }

    private Object toImplementation(Object value) {
        this.specificBitMasks = value.getClass().isAnnotationPresent(UseLegacyMetadata.class) ? 32 : 0;
        UnaryOperator<Object>[] converters = this.getRootAdapters();
        if (converters != null) {
            for (UnaryOperator<Object> t : converters) {
                Object c = t.apply(value);
                if (c == null) continue;
                return c;
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marshal(Object object, XMLEventWriter output, TransformVersion version) throws XMLStreamException, JAXBException {
        output = new TransformingWriter(output, version);
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, output);
        }
        finally {
            context.finish();
        }
        output.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Object object, Result output) throws JAXBException {
        object = this.toImplementation(object);
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            try {
                this.marshal(object, OutputFactory.createXMLEventWriter(output), version);
            }
            catch (XMLStreamException e) {
                throw new JAXBException(e);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, output);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Object object, OutputStream output) throws JAXBException {
        object = this.toImplementation(object);
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            try {
                this.marshal(object, OutputFactory.createXMLEventWriter(output, this.getEncoding()), version);
            }
            catch (XMLStreamException e) {
                throw new JAXBException(e);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, output);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Object object, File output) throws JAXBException {
        block11: {
            object = this.toImplementation(object);
            TransformVersion version = this.getTransformVersion();
            if (version != null) {
                try (BufferedOutputStream s = new BufferedOutputStream(new FileOutputStream(output));){
                    this.marshal(object, OutputFactory.createXMLEventWriter(s, this.getEncoding()), version);
                    break block11;
                }
                catch (IOException | XMLStreamException e) {
                    throw new JAXBException(e);
                }
            }
            Context context = this.begin();
            try {
                this.marshaller.marshal(object, output);
            }
            finally {
                context.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Object object, Writer output) throws JAXBException {
        object = this.toImplementation(object);
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            try {
                this.marshal(object, OutputFactory.createXMLEventWriter(output), version);
            }
            catch (XMLStreamException e) {
                throw new JAXBException(e);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, output);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Object object, ContentHandler output) throws JAXBException {
        object = this.toImplementation(object);
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            try {
                this.marshal(object, OutputFactory.createXMLEventWriter(output), version);
            }
            catch (XMLStreamException e) {
                throw new JAXBException(e);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, output);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Object object, Node output) throws JAXBException {
        object = this.toImplementation(object);
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            try {
                this.marshal(object, OutputFactory.createXMLEventWriter(output), version);
            }
            catch (XMLStreamException e) {
                throw new JAXBException(e);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, output);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Object object, XMLStreamWriter output) throws JAXBException {
        object = this.toImplementation(object);
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            try {
                this.marshal(object, OutputFactory.createXMLEventWriter(output), version);
            }
            catch (XMLStreamException e) {
                throw new JAXBException(e);
            }
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, output);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Object object, XMLEventWriter output) throws JAXBException {
        object = this.toImplementation(object);
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            output = new TransformingWriter(output, version);
        }
        Context context = this.begin();
        try {
            this.marshaller.marshal(object, output);
        }
        finally {
            context.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getNode(Object object) throws JAXBException {
        object = this.toImplementation(object);
        TransformVersion version = this.getTransformVersion();
        if (version != null) {
            throw new UnsupportedOperationException();
        }
        Context context = this.begin();
        try {
            Node node = this.marshaller.getNode(object);
            return node;
        }
        finally {
            context.finish();
        }
    }

    @Override
    void setStandardProperty(String name, Object value) throws PropertyException {
        this.marshaller.setProperty(name, value);
    }

    @Override
    Object getStandardProperty(String name) throws PropertyException {
        return this.marshaller.getProperty(name);
    }

    @Override
    public <A extends XmlAdapter<?, ?>> void setAdapter(Class<A> type, A adapter) {
        super.setAdapter(type, adapter);
        this.marshaller.setAdapter(type, adapter);
    }

    @Override
    public <A extends XmlAdapter<?, ?>> A getAdapter(Class<A> type) {
        return this.marshaller.getAdapter(type);
    }

    @Override
    public void setSchema(Schema schema) {
        super.setSchema(schema);
        this.marshaller.setSchema(schema);
    }

    @Override
    public Schema getSchema() {
        return this.marshaller.getSchema();
    }

    @Override
    public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
        super.setEventHandler(handler);
        this.marshaller.setEventHandler(handler);
    }

    @Override
    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.marshaller.getEventHandler();
    }

    @Override
    public void setAttachmentMarshaller(AttachmentMarshaller am) {
        if (!this.isPropertySaved(AttachmentMarshaller.class)) {
            this.saveProperty(AttachmentMarshaller.class, this.marshaller.getAttachmentMarshaller());
        }
        this.marshaller.setAttachmentMarshaller(am);
    }

    @Override
    public AttachmentMarshaller getAttachmentMarshaller() {
        return this.marshaller.getAttachmentMarshaller();
    }

    @Override
    public void setListener(Marshaller.Listener listener) {
        if (!this.isPropertySaved(Marshaller.Listener.class)) {
            this.saveProperty(Marshaller.Listener.class, this.marshaller.getListener());
        }
        this.marshaller.setListener(listener);
    }

    @Override
    public Marshaller.Listener getListener() {
        return this.marshaller.getListener();
    }
}

