/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.OperationResult;
import org.apache.sis.internal.converter.SurjectiveConverter;
import org.apache.sis.internal.feature.FeatureUtilities;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;
import org.opengis.feature.AttributeType;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureAssociationRole;
import org.opengis.feature.FeatureType;
import org.opengis.feature.IdentifiedType;
import org.opengis.feature.InvalidPropertyValueException;
import org.opengis.feature.Operation;
import org.opengis.feature.Property;
import org.opengis.feature.PropertyNotFoundException;
import org.opengis.feature.PropertyType;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

final class StringJoinOperation
extends AbstractOperation {
    private static final long serialVersionUID = 2303047827010821381L;
    static final char ESCAPE = '\\';
    private static final ParameterDescriptorGroup EMPTY_PARAMS = FeatureUtilities.parameters("StringJoin", new ParameterDescriptor[0]);
    private final String[] attributeNames;
    private final ObjectConverter<? super String, ?>[] converters;
    private transient Set<String> dependencies;
    private final AttributeType<String> resultType;
    final String prefix;
    final String suffix;
    final String delimiter;

    StringJoinOperation(Map<String, ?> identification, String delimiter, String prefix, String suffix, PropertyType[] singleAttributes) throws UnconvertibleObjectException {
        super(identification);
        this.attributeNames = new String[singleAttributes.length];
        this.converters = new ObjectConverter[singleAttributes.length];
        for (int i = 0; i < singleAttributes.length; ++i) {
            PropertyType propertyType = singleAttributes[i];
            ArgumentChecks.ensureNonNullElement("singleAttributes", i, propertyType);
            GenericName name = propertyType.getName();
            int maximumOccurs = 0;
            PropertyNotFoundException cause = null;
            boolean isAssociation = propertyType instanceof FeatureAssociationRole;
            if (isAssociation) {
                FeatureAssociationRole role = (FeatureAssociationRole)propertyType;
                FeatureType ft = role.getValueType();
                maximumOccurs = role.getMaximumOccurs();
                try {
                    propertyType = ft.getProperty("sis:identifier");
                }
                catch (PropertyNotFoundException e) {
                    cause = e;
                }
            }
            if (propertyType instanceof Operation) {
                propertyType = ((Operation)propertyType).getResult();
            }
            if (!(propertyType instanceof AttributeType)) {
                Class<PropertyType>[] inf = Classes.getLeafInterfaces(Classes.getClass(propertyType), PropertyType.class);
                throw new IllegalArgumentException(Resources.forProperties(identification).getString((short)29, name, inf.length != 0 ? inf[0] : null), cause);
            }
            if ((maximumOccurs |= ((AttributeType)propertyType).getMaximumOccurs()) > 1) {
                throw new IllegalArgumentException(Resources.forProperties(identification).getString((short)53, name));
            }
            this.attributeNames[i] = name.toString();
            ForFeature converter = ObjectConverters.find(String.class, ((AttributeType)propertyType).getValueClass());
            if (isAssociation) {
                converter = new ForFeature(converter);
            }
            this.converters[i] = converter;
        }
        this.resultType = FeatureOperations.POOL.unique(new DefaultAttributeType<Object>(this.resultIdentification(identification), String.class, 1, 1, null, new AttributeType[0]));
        this.delimiter = delimiter;
        this.prefix = prefix == null ? "" : prefix;
        this.suffix = suffix == null ? "" : suffix;
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return EMPTY_PARAMS;
    }

    @Override
    public IdentifiedType getResult() {
        return this.resultType;
    }

    @Override
    public synchronized Set<String> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = CollectionsExt.immutableSet(true, this.attributeNames);
        }
        return this.dependencies;
    }

    static <S> Object format(ObjectConverter<S, ?> converter, Object value) {
        return converter.apply(converter.getSourceClass().cast(value));
    }

    @Override
    public Property apply(Feature feature, ParameterValueGroup parameters) {
        ArgumentChecks.ensureNonNull("feature", feature);
        return new Result(feature);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.attributeNames) + 37 * Objects.hash(this.delimiter, this.prefix, this.suffix);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            StringJoinOperation that = (StringJoinOperation)obj;
            return Arrays.equals(this.attributeNames, that.attributeNames) && Arrays.equals(this.converters, that.converters) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.suffix, that.suffix);
        }
        return false;
    }

    @Override
    void formatResultFormula(Appendable buffer) throws IOException {
        String escape = "\\" + this.delimiter;
        if (this.prefix != null) {
            buffer.append(this.prefix);
        }
        for (int i = 0; i < this.attributeNames.length; ++i) {
            if (i != 0) {
                buffer.append(this.delimiter);
            }
            buffer.append(this.attributeNames[i].replace(this.delimiter, escape));
        }
        if (this.suffix != null) {
            buffer.append(this.suffix);
        }
    }

    private static final class ForFeature
    extends SurjectiveConverter<Object, Object>
    implements Serializable {
        private static final long serialVersionUID = 2208230611402221572L;
        final ObjectConverter<? super String, ?> converter;

        ForFeature(ObjectConverter<? super String, ?> converter) {
            this.converter = converter;
        }

        @Override
        public ObjectConverter<Object, Object> inverse() {
            return this;
        }

        @Override
        public Class<Object> getSourceClass() {
            return Object.class;
        }

        @Override
        public Class<Object> getTargetClass() {
            return Object.class;
        }

        @Override
        public Object apply(Object f) {
            return f != null ? StringJoinOperation.format(this.converter.inverse(), ((Feature)f).getPropertyValue("sis:identifier")) : null;
        }
    }

    private final class Result
    extends OperationResult<String> {
        private static final long serialVersionUID = -555025854115540108L;

        Result(Feature feature) {
            super(StringJoinOperation.this.resultType, feature);
        }

        @Override
        public String getValue() throws UnconvertibleObjectException {
            StringBuilder sb = new StringBuilder();
            String sep = StringJoinOperation.this.prefix;
            String name = null;
            Object value = null;
            try {
                for (int i = 0; i < StringJoinOperation.this.attributeNames.length; ++i) {
                    name = StringJoinOperation.this.attributeNames[i];
                    value = this.feature.getPropertyValue(name);
                    value = StringJoinOperation.format(StringJoinOperation.this.converters[i].inverse(), value);
                    sb.append(sep);
                    sep = StringJoinOperation.this.delimiter;
                    if (value == null) continue;
                    int startAt = sb.length();
                    int j = sb.append(value).length();
                    while (--j >= startAt) {
                        if (sb.charAt(j) != '\\') continue;
                        sb.insert(j, '\\');
                    }
                    j = startAt;
                    while ((j = sb.indexOf(sep, j)) >= 0) {
                        sb.insert(j, '\\');
                        j += sep.length() + 1;
                    }
                }
            }
            catch (ClassCastException e) {
                if (value == null) {
                    throw e;
                }
                throw new UnconvertibleObjectException(Errors.format((short)63, name), e);
            }
            return sb.append(StringJoinOperation.this.suffix).toString();
        }

        @Override
        public void setValue(String value) throws InvalidPropertyValueException {
            int lower;
            int endAt = value.length() - StringJoinOperation.this.suffix.length();
            boolean prefixMatches = value.startsWith(StringJoinOperation.this.prefix);
            if (!prefixMatches || !value.endsWith(StringJoinOperation.this.suffix)) {
                throw new InvalidPropertyValueException(Errors.format((short)136, this.getName(), prefixMatches ? 1 : 0, prefixMatches ? StringJoinOperation.this.suffix : StringJoinOperation.this.prefix, prefixMatches ? value.substring(Math.max(0, endAt)) : CharSequences.token(value, 0)));
            }
            Object[] values = new Object[StringJoinOperation.this.attributeNames.length];
            int upper = lower = StringJoinOperation.this.prefix.length();
            int count = 0;
            boolean done = false;
            do {
                if ((upper = value.indexOf(StringJoinOperation.this.delimiter, upper)) >= 0 && upper < endAt) {
                    int escape;
                    for (escape = upper; escape != 0 && value.charAt(escape - 1) == '\\'; --escape) {
                    }
                    if ((upper - escape & 1) != 0) {
                        upper += StringJoinOperation.this.delimiter.length() + 1;
                        continue;
                    }
                } else {
                    upper = endAt;
                    done = true;
                }
                String element = value.substring(lower, upper);
                int i = 0;
                while ((i = element.indexOf(92, i)) >= 0) {
                    if (i >= (element = new StringBuilder(element.length() - 1).append(element, 0, i).append(element, i + 1, element.length()).toString()).length()) continue;
                    if (element.charAt(i) == '\\') {
                        ++i;
                        continue;
                    }
                    assert (element.startsWith(StringJoinOperation.this.delimiter, i)) : element;
                    i += StringJoinOperation.this.delimiter.length();
                }
                if (!element.isEmpty() && count < values.length) {
                    ObjectConverter<String, ?> converter = StringJoinOperation.this.converters[count];
                    if (converter instanceof ForFeature) {
                        converter = ((ForFeature)converter).converter;
                    }
                    try {
                        values[count] = converter.apply(element);
                    }
                    catch (UnconvertibleObjectException e) {
                        throw new InvalidPropertyValueException(Errors.format((short)4, StringJoinOperation.this.attributeNames[count], element), (Throwable)e);
                    }
                }
                ++count;
                lower = upper += StringJoinOperation.this.delimiter.length();
            } while (!done);
            if (values.length != count) {
                throw new InvalidPropertyValueException(Resources.format((short)68, this.getName(), value, values.length, count));
            }
            for (int i = 0; i < values.length; ++i) {
                Feature f = this.feature;
                String name = StringJoinOperation.this.attributeNames[i];
                if (StringJoinOperation.this.converters[i] instanceof ForFeature) {
                    f = (Feature)f.getPropertyValue(name);
                    name = "sis:identifier";
                }
                f.setPropertyValue(name, values[i]);
            }
        }
    }
}

