/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.Localized;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.feature.IdentifiedType;
import org.opengis.feature.PropertyNotFoundException;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

public abstract class TypeBuilder
implements Localized {
    private final Map<String, Object> identification;

    TypeBuilder(TypeBuilder builder) {
        this.identification = new HashMap<String, Object>(builder.identification);
    }

    TypeBuilder(Locale locale) {
        this.identification = new HashMap<String, Object>(4);
        this.putIfNonNull("locale", locale);
    }

    final void reset() {
        Object locale = this.identification.get("locale");
        this.identification.clear();
        this.putIfNonNull("locale", locale);
    }

    final void initialize(IdentifiedType template) {
        this.putIfNonNull("name", template.getName());
        this.putIfNonNull("definition", template.getDefinition());
        this.putIfNonNull("designation", template.getDesignation());
        this.putIfNonNull("description", template.getDescription());
        if (template instanceof Deprecable && ((Deprecable)template).isDeprecated()) {
            this.identification.put("deprecated", Boolean.TRUE);
        }
    }

    private void putIfNonNull(String key, Object value) {
        if (value != null) {
            this.identification.put(key, value);
        }
    }

    final Map<String, Object> identification() {
        int length;
        String name;
        if (this.identification.get("name") == null && (name = this.getDefaultName()) != null && (length = name.length()) != 0) {
            int n;
            int lc;
            int c = name.codePointAt(0);
            if (c != (lc = Character.toLowerCase(c)) && ((n = Character.charCount(c)) >= length || Character.isLowerCase(name.codePointAt(n)))) {
                StringBuilder buffer = new StringBuilder(length);
                name = buffer.appendCodePoint(lc).append(name, n, length).toString();
            }
            this.identification.put("name", this.createLocalName(name));
        }
        return this.identification;
    }

    abstract void clearCache();

    abstract GenericName createLocalName(CharSequence var1);

    abstract GenericName createGenericName(CharSequence ... var1);

    public GenericName getName() {
        return (GenericName)this.identification().get("name");
    }

    String getDefaultName() {
        return null;
    }

    final String getDisplayName() {
        GenericName name = this.getName();
        return name != null ? name.toString() : Vocabulary.getResources(this.identification).getString((short)208);
    }

    public TypeBuilder setName(GenericName name) {
        this.ensureNonNull("name", name);
        if (!name.equals(this.identification.put("name", name))) {
            this.clearCache();
        }
        return this;
    }

    public TypeBuilder setName(CharSequence localPart) {
        this.ensureNonEmpty("localPart", localPart);
        return this.setName(this.createLocalName(localPart));
    }

    public TypeBuilder setName(CharSequence ... components) {
        this.ensureNonNull("components", components);
        if (components.length == 0) {
            throw new IllegalArgumentException(this.errors().getString((short)29, "components"));
        }
        return this.setName(this.createGenericName(components));
    }

    public CharSequence getDefinition() {
        return (CharSequence)this.identification.get("definition");
    }

    public TypeBuilder setDefinition(CharSequence definition) {
        if (!Objects.equals(definition, this.identification.put("definition", definition))) {
            this.clearCache();
        }
        return this;
    }

    public CharSequence getDesignation() {
        return (CharSequence)this.identification.get("designation");
    }

    public TypeBuilder setDesignation(CharSequence designation) {
        if (!Objects.equals(designation, this.identification.put("designation", designation))) {
            this.clearCache();
        }
        return this;
    }

    public CharSequence getDescription() {
        return (CharSequence)this.identification.get("description");
    }

    public TypeBuilder setDescription(CharSequence description) {
        if (!Objects.equals(description, this.identification.put("description", description))) {
            this.clearCache();
        }
        return this;
    }

    public boolean isDeprecated() {
        return Boolean.TRUE.equals(this.identification.get("deprecated"));
    }

    public TypeBuilder setDeprecated(boolean deprecated) {
        Boolean wrapper = deprecated;
        Object previous = this.identification.put("deprecated", wrapper);
        if (previous == null) {
            previous = Boolean.FALSE;
        }
        if (!Objects.equals(wrapper, previous)) {
            this.clearCache();
        }
        return this;
    }

    final <E extends TypeBuilder> E forName(List<E> types, String name, boolean nonAmbiguous) {
        TypeBuilder best = null;
        TypeBuilder ambiguity = null;
        int depth = Integer.MAX_VALUE;
        block0: for (TypeBuilder type : types) {
            GenericName candidate = type.getName();
            int d = 0;
            while (candidate != null) {
                if (name.equals(candidate.toString())) {
                    if (d < depth) {
                        best = type;
                        ambiguity = null;
                        depth = d;
                        continue block0;
                    }
                    if (d == depth) {
                        ambiguity = type;
                        continue block0;
                    }
                }
                if (!(candidate instanceof ScopedName)) continue block0;
                candidate = ((ScopedName)candidate).tail();
                ++d;
            }
        }
        if (ambiguity != null && nonAmbiguous) {
            throw new PropertyNotFoundException(this.errors().getString((short)1, best.getName(), ambiguity.getName(), name));
        }
        return (E)best;
    }

    @Override
    public Locale getLocale() {
        return (Locale)this.identification.get("locale");
    }

    final Errors errors() {
        return Errors.getResources(this.identification);
    }

    final Resources resources() {
        return Resources.forProperties(this.identification);
    }

    final void ensureNonNull(String name, Object value) {
        if (value == null) {
            throw new NullArgumentException(this.errors().getString((short)113, name));
        }
    }

    final void ensureAlive(TypeBuilder owner) {
        if (owner == null) {
            throw new IllegalStateException(this.errors().getString((short)23, this.getClass()));
        }
    }

    final void ensureNonEmpty(String name, CharSequence text) {
        if (text == null) {
            throw new NullArgumentException(this.errors().getString((short)113, name));
        }
        if (text.length() == 0) {
            throw new IllegalArgumentException(this.errors().getString((short)29, name));
        }
    }

    public String toString() {
        return this.appendStringTo(new StringBuilder(Classes.getShortClassName(this))).toString();
    }

    final StringBuilder appendStringTo(StringBuilder buffer) {
        this.toStringInternal(buffer.append("[\u201c").append(this.getDisplayName()).append('\u201d'));
        return buffer.append(']');
    }

    void toStringInternal(StringBuilder buffer) {
    }

    void remove() {
    }

    public abstract IdentifiedType build() throws IllegalStateException;
}

