/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.logging.Level;
import java.util.stream.Collector;
import org.apache.sis.image.ErrorHandler;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.TileErrorHandler;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.system.CommonExecutor;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;

public class TileOpExecutor {
    private final int minTileX;
    private final int minTileY;
    private final int maxTileX;
    private final int maxTileY;
    private Shape areaOfInterest;
    private TileErrorHandler errorHandler = TileErrorHandler.THROW;

    public TileOpExecutor(RenderedImage image, Rectangle aoi) {
        if (aoi != null) {
            int tileWidth = image.getTileWidth();
            int tileHeight = image.getTileHeight();
            long tileGridXOffset = image.getTileGridXOffset();
            long tileGridYOffset = image.getTileGridYOffset();
            this.minTileX = Math.toIntExact(Math.floorDiv((long)aoi.x - tileGridXOffset, tileWidth));
            this.minTileY = Math.toIntExact(Math.floorDiv((long)aoi.y - tileGridYOffset, tileHeight));
            this.maxTileX = Math.toIntExact(Math.floorDiv((long)aoi.x + ((long)aoi.width - 1L) - tileGridXOffset, tileWidth));
            this.maxTileY = Math.toIntExact(Math.floorDiv((long)aoi.y + ((long)aoi.height - 1L) - tileGridYOffset, tileHeight));
        } else {
            this.minTileX = image.getMinTileX();
            this.minTileY = image.getMinTileY();
            this.maxTileX = Math.addExact(this.minTileX, image.getNumXTiles() - 1);
            this.maxTileY = Math.addExact(this.minTileY, image.getNumYTiles() - 1);
        }
    }

    public final void setAreaOfInterest(RenderedImage image, Shape aoi) {
        if (aoi != null && image != null) {
            Rectangle bounds = this.getTileIndices();
            bounds.x = Math.decrementExact(ImageUtilities.tileToPixelX(image, Math.incrementExact(bounds.x)) - 1);
            bounds.y = Math.decrementExact(ImageUtilities.tileToPixelY(image, Math.incrementExact(bounds.y)) - 1);
            bounds.width = Math.addExact(Math.multiplyExact(bounds.width, image.getTileWidth() - 2), 2);
            bounds.height = Math.addExact(Math.multiplyExact(bounds.height, image.getTileHeight() - 2), 2);
            if (aoi.contains(bounds)) {
                aoi = null;
            }
        }
        this.areaOfInterest = aoi;
    }

    public final void setErrorHandler(ErrorHandler handler, Class<?> sourceClass, String sourceMethod) {
        ArgumentChecks.ensureNonNull("handler", handler);
        this.errorHandler = handler == ErrorHandler.THROW ? TileErrorHandler.THROW : new TileErrorHandler(handler, sourceClass, sourceMethod);
    }

    public final boolean isMultiTiled() {
        return (this.maxTileX - this.minTileX | this.maxTileY - this.minTileY) > 0;
    }

    public final Rectangle getTileIndices() {
        return new Rectangle(this.minTileX, this.minTileY, Math.incrementExact(Math.subtractExact(this.maxTileX, this.minTileX)), Math.incrementExact(Math.subtractExact(this.maxTileY, this.minTileY)));
    }

    protected void readFrom(Raster source) throws Exception {
    }

    protected void writeTo(WritableRaster target) throws Exception {
    }

    public final void readFrom(RenderedImage source) {
        ErrorHandler.Report errors = new ErrorHandler.Report();
        block2: for (int ty = this.minTileY; ty <= this.maxTileY; ++ty) {
            for (int tx = this.minTileX; tx <= this.maxTileX; ++tx) {
                try {
                    this.readFrom(source.getTile(tx, ty));
                    continue;
                }
                catch (Exception ex) {
                    errors.add(new Point(tx, ty), TileOpExecutor.trimImagingWrapper(ex), null);
                    if (this.errorHandler == TileErrorHandler.THROW) continue block2;
                }
            }
        }
        this.errorHandler.publish(errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeTo(WritableRenderedImage target) {
        ErrorHandler.Report errors = new ErrorHandler.Report();
        for (int ty = this.minTileY; ty <= this.maxTileY; ++ty) {
            for (int tx = this.minTileX; tx <= this.maxTileX; ++tx) {
                try {
                    WritableRaster tile = target.getWritableTile(tx, ty);
                    try {
                        this.writeTo(tile);
                        continue;
                    }
                    finally {
                        target.releaseWritableTile(tx, ty);
                    }
                }
                catch (Exception ex) {
                    Point tile = new Point(tx, ty);
                    errors.add(tile, TileOpExecutor.trimImagingWrapper(ex), () -> Resources.forLocale(null).getLogRecord(Level.WARNING, (short)14, tile.x, tile.y));
                }
            }
        }
        this.errorHandler.publish(errors);
    }

    public final void parallelReadFrom(RenderedImage source) {
        if (this.isMultiTiled()) {
            this.executeOnReadable(source, TileOpExecutor.executor((ignore, tile) -> {
                try {
                    this.readFrom((Raster)tile);
                }
                catch (Exception ex) {
                    throw Worker.rethrowOrWrap(ex);
                }
            }));
        } else {
            this.readFrom(source);
        }
    }

    public final void parallelWriteTo(WritableRenderedImage target) {
        if (this.isMultiTiled()) {
            this.executeOnWritable(target, TileOpExecutor.executor((ignore, tile) -> {
                try {
                    this.writeTo((WritableRaster)tile);
                }
                catch (Exception ex) {
                    throw Worker.rethrowOrWrap(ex);
                }
            }));
        } else {
            this.writeTo(target);
        }
    }

    private static <RT extends Raster> Collector<RT, Void, Void> executor(BiConsumer<Void, RT> action) {
        return Collector.of(() -> null, action, (old, ignore) -> old, new Collector.Characteristics[0]);
    }

    public final <A, R> R executeOnReadable(RenderedImage source, Collector<? super Raster, A, R> collector) {
        ArgumentChecks.ensureNonNull("source", source);
        ArgumentChecks.ensureNonNull("collector", collector);
        return ReadWork.execute(this, source, collector, this.errorHandler);
    }

    public final <A, R> R executeOnWritable(WritableRenderedImage target, Collector<? super WritableRaster, A, R> collector) {
        ArgumentChecks.ensureNonNull("target", target);
        ArgumentChecks.ensureNonNull("collector", collector);
        return WriteWork.execute(this, target, collector, this.errorHandler);
    }

    private static Throwable trimImagingWrapper(Throwable ex) {
        while (ex.getClass() == ImagingOpException.class && ex.getMessage() == null && ex.getSuppressed().length == 0) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                return ex;
            }
            ex = cause;
        }
        if (ex instanceof Exception) {
            ex = Exceptions.unwrap((Exception)ex);
        }
        return ex;
    }

    private static final class ReadWork<A>
    extends Worker<RenderedImage, Raster, A> {
        private ReadWork(Cursor<RenderedImage, A> cursor, Collector<? super Raster, A, ?> collector) {
            super(cursor, collector);
        }

        @Override
        protected void executeOnCurrentTile() {
            Raster tile = this.cursor.image.getTile(this.tx, this.ty);
            this.processor.accept(this.accumulator, tile);
        }

        static <A, R> R execute(TileOpExecutor executor, RenderedImage source, Collector<? super Raster, A, R> collector, TileErrorHandler errorHandler) {
            TileOpExecutor tileOpExecutor = executor;
            Objects.requireNonNull(tileOpExecutor);
            Cursor cursor = new Cursor(tileOpExecutor, source, collector, errorHandler.isThrow());
            Future[] workers = new Future[cursor.getNumWorkers()];
            for (int i = 0; i < workers.length; ++i) {
                workers[i] = CommonExecutor.instance().submit(new ReadWork<A>(cursor, collector));
            }
            ReadWork<A> worker = new ReadWork<A>(cursor, collector);
            worker.run();
            return cursor.finish(workers, collector, errorHandler);
        }
    }

    private static final class WriteWork<A>
    extends Worker<WritableRenderedImage, WritableRaster, A> {
        private WriteWork(Cursor<WritableRenderedImage, A> cursor, Collector<? super WritableRaster, A, ?> collector) {
            super(cursor, collector);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void executeOnCurrentTile() {
            WritableRenderedImage image = (WritableRenderedImage)this.cursor.image;
            int tx = this.tx;
            int ty = this.ty;
            WritableRaster tile = image.getWritableTile(tx, ty);
            try {
                this.processor.accept(this.accumulator, tile);
            }
            finally {
                image.releaseWritableTile(tx, ty);
            }
        }

        static <A, R> R execute(TileOpExecutor executor, WritableRenderedImage target, Collector<? super WritableRaster, A, R> collector, TileErrorHandler errorHandler) {
            TileOpExecutor tileOpExecutor = executor;
            Objects.requireNonNull(tileOpExecutor);
            Cursor cursor = new Cursor(tileOpExecutor, (RenderedImage)target, collector, false);
            Future[] workers = new Future[cursor.getNumWorkers()];
            for (int i = 0; i < workers.length; ++i) {
                workers[i] = CommonExecutor.instance().submit(new WriteWork<A>(cursor, collector));
            }
            WriteWork<A> worker = new WriteWork<A>(cursor, collector);
            worker.run();
            return cursor.finish(workers, collector, errorHandler);
        }
    }

    private static abstract class Worker<RI extends RenderedImage, RT extends Raster, A>
    implements Runnable {
        protected final Cursor<RI, A> cursor;
        protected int tx;
        protected int ty;
        protected final BiConsumer<A, ? super RT> processor;
        protected final A accumulator;

        protected Worker(Cursor<RI, A> cursor, Collector<? super RT, A, ?> collector) {
            this.cursor = cursor;
            this.processor = collector.accumulator();
            this.accumulator = collector.supplier().get();
        }

        @Override
        public final void run() {
            while (this.cursor.next(this)) {
                try {
                    if (!this.cursor.intersectAOI(this)) continue;
                    this.executeOnCurrentTile();
                }
                catch (Exception ex) {
                    this.cursor.recordError(new Point(this.tx, this.ty), TileOpExecutor.trimImagingWrapper(ex));
                }
            }
            this.cursor.accumulate(this.accumulator);
        }

        protected abstract void executeOnCurrentTile();

        static ImagingOpException rethrowOrWrap(Throwable ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            return (ImagingOpException)new ImagingOpException(null).initCause(cause != null ? cause : ex);
        }
    }

    private final class Cursor<RI extends RenderedImage, A>
    extends AtomicInteger {
        final RI image;
        private final int numXTiles;
        private final BinaryOperator<A> combiner;
        private A accumulator;
        private final ErrorHandler.Report errors;
        private final boolean stopOnError;
        final /* synthetic */ TileOpExecutor this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        Cursor(RI image, Collector<?, A, ?> collector, boolean stopOnError) {
            this.this$0 = (TileOpExecutor)n;
            this.image = image;
            this.combiner = collector.combiner();
            this.numXTiles = Math.incrementExact(Math.subtractExact(n.maxTileX, n.minTileX));
            this.stopOnError = stopOnError;
            this.errors = new ErrorHandler.Report();
        }

        final int getNumWorkers() {
            return Math.max((int)Math.min((long)CommonExecutor.PARALLELISM, (long)this.numXTiles * ((long)this.this$0.maxTileY - (long)this.this$0.minTileY + 1L) - 1L), 0);
        }

        final boolean next(Worker<RI, ?, A> indices) {
            int index = this.getAndIncrement();
            if (index >= 0) {
                indices.tx = Math.addExact(this.this$0.minTileX, index % this.numXTiles);
                indices.ty = Math.addExact(this.this$0.minTileY, index / this.numXTiles);
                return indices.ty <= this.this$0.maxTileY;
            }
            return false;
        }

        final boolean intersectAOI(Worker<RI, ?, A> indices) {
            if (this.this$0.areaOfInterest == null) {
                return true;
            }
            Rectangle bounds = new Rectangle(this.image.getTileWidth(), this.image.getTileHeight());
            bounds.x = Math.addExact(Math.multiplyExact(indices.tx, bounds.width), this.image.getTileGridXOffset());
            bounds.y = Math.addExact(Math.multiplyExact(indices.ty, bounds.height), this.image.getTileGridYOffset());
            return this.this$0.areaOfInterest.intersects(bounds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void accumulate(A result) {
            if (result != null) {
                Cursor cursor = this;
                synchronized (cursor) {
                    this.accumulator = this.accumulator == null ? result : this.combiner.apply(this.accumulator, result);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final <R> R finish(Future<?>[] workers, Collector<?, A, R> collector, TileErrorHandler errorHandler) {
            R result;
            for (int i = 0; i < workers.length; ++i) {
                if (!CommonExecutor.unschedule(workers[i])) continue;
                workers[i] = null;
            }
            for (Future<?> task : workers) {
                try {
                    if (task == null) continue;
                    task.get();
                }
                catch (ExecutionException ex) {
                    throw Worker.rethrowOrWrap(ex.getCause());
                }
                catch (InterruptedException ex) {
                    this.recordError(null, ex);
                    break;
                }
            }
            Cursor cursor = this;
            synchronized (cursor) {
                result = collector.finisher().apply(this.accumulator);
            }
            errorHandler.publish(this.errors);
            return result;
        }

        final void recordError(Point tile, Throwable ex) {
            if (this.stopOnError) {
                this.set(Integer.MIN_VALUE);
            }
            this.errors.add(tile, ex, null);
        }

        @Override
        public String toString() {
            int index = this.get();
            Object tile = "done";
            if (index >= 0) {
                int tx = Math.addExact(this.this$0.minTileX, index % this.numXTiles);
                int ty = Math.addExact(this.this$0.minTileY, index / this.numXTiles);
                if (ty <= this.this$0.maxTileY) {
                    tile = "(" + tx + ", " + ty + ")";
                }
            }
            return Strings.toString(this.getClass(), "image", Classes.getShortClassName(this.image), "numWorkers", this.getNumWorkers(), "tile", tile);
        }
    }
}

