/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.temporal;

import java.util.Collection;
import java.util.Date;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.apache.sis.internal.temporal.DefaultInstant;
import org.apache.sis.internal.temporal.DefaultPeriod;
import org.apache.sis.internal.temporal.DefaultPeriodDuration;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.Extent;
import org.opengis.temporal.Calendar;
import org.opengis.temporal.CalendarDate;
import org.opengis.temporal.CalendarEra;
import org.opengis.temporal.Clock;
import org.opengis.temporal.ClockTime;
import org.opengis.temporal.DateAndTime;
import org.opengis.temporal.IndeterminateValue;
import org.opengis.temporal.Instant;
import org.opengis.temporal.IntervalLength;
import org.opengis.temporal.JulianDate;
import org.opengis.temporal.OrdinalEra;
import org.opengis.temporal.OrdinalPosition;
import org.opengis.temporal.OrdinalReferenceSystem;
import org.opengis.temporal.Period;
import org.opengis.temporal.PeriodDuration;
import org.opengis.temporal.TemporalCoordinate;
import org.opengis.temporal.TemporalCoordinateSystem;
import org.opengis.temporal.TemporalFactory;
import org.opengis.temporal.TemporalPosition;
import org.opengis.temporal.TemporalReferenceSystem;
import org.opengis.util.InternationalString;

public final class DefaultTemporalFactory
implements TemporalFactory {
    public static final TemporalFactory INSTANCE = new DefaultTemporalFactory();

    private DefaultTemporalFactory() {
    }

    @Override
    public Instant createInstant(Date date) {
        return new DefaultInstant(date);
    }

    @Override
    public Period createPeriod(Instant begin, Instant end) {
        return new DefaultPeriod(begin, end);
    }

    @Override
    public PeriodDuration createPeriodDuration(InternationalString years, InternationalString months, InternationalString week, InternationalString days, InternationalString hours, InternationalString minutes, InternationalString seconds) {
        return new DefaultPeriodDuration(years, months, week, days, hours, minutes, seconds);
    }

    static UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException(Errors.format((short)87, "sis-temporal"));
    }

    @Override
    public Calendar createCalendar(Identifier name, Extent domainOfValidity) {
        throw DefaultTemporalFactory.unsupported();
    }

    @Override
    public Calendar createCalendar(Identifier name, Extent domainOfValidity, Collection<CalendarEra> referenceFrame, Clock timeBasis) {
        throw DefaultTemporalFactory.unsupported();
    }

    @Override
    public CalendarDate createCalendarDate(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition, InternationalString calendarEraName, int[] calendarDate) {
        throw DefaultTemporalFactory.unsupported();
    }

    @Override
    public CalendarEra createCalendarEra(InternationalString name, InternationalString referenceEvent, CalendarDate referenceDate, JulianDate julianReference, Period epochOfUse) {
        throw DefaultTemporalFactory.unsupported();
    }

    @Override
    public Clock createClock(Identifier name, Extent domainOfValidity, InternationalString referenceEvent, ClockTime referenceTime, ClockTime utcReference) {
        throw DefaultTemporalFactory.unsupported();
    }

    @Override
    public ClockTime createClockTime(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition, Number[] clockTime) {
        throw DefaultTemporalFactory.unsupported();
    }

    @Override
    public DateAndTime createDateAndTime(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition, InternationalString calendarEraName, int[] calendarDate, Number[] clockTime) {
        throw DefaultTemporalFactory.unsupported();
    }

    @Override
    public IntervalLength createIntervalLenght(Unit unit, int radix, int factor, int value) {
        throw DefaultTemporalFactory.unsupported();
    }

    @Override
    public JulianDate createJulianDate(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition, Number coordinateValue) {
        throw DefaultTemporalFactory.unsupported();
    }

    @Override
    public OrdinalEra createOrdinalEra(InternationalString name, Date beginning, Date end, Collection<OrdinalEra> member) {
        throw DefaultTemporalFactory.unsupported();
    }

    @Override
    public OrdinalPosition createOrdinalPosition(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition, OrdinalEra ordinalPosition) {
        throw DefaultTemporalFactory.unsupported();
    }

    @Override
    public OrdinalReferenceSystem createOrdinalReferenceSystem(Identifier name, Extent domainOfValidity, Collection<OrdinalEra> ordinalEraSequence) {
        throw DefaultTemporalFactory.unsupported();
    }

    @Override
    public TemporalCoordinate createTemporalCoordinate(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition, Number coordinateValue) {
        throw DefaultTemporalFactory.unsupported();
    }

    @Override
    public TemporalCoordinateSystem createTemporalCoordinateSystem(Identifier name, Extent domainOfValidity, Date origin, Unit<Time> interval) {
        throw DefaultTemporalFactory.unsupported();
    }

    @Override
    public TemporalPosition createTemporalPosition(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition) {
        throw DefaultTemporalFactory.unsupported();
    }

    @Override
    public TemporalReferenceSystem createTemporalReferenceSystem(Identifier name, Extent domainOfValidity) {
        throw DefaultTemporalFactory.unsupported();
    }
}

