/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.resources;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.apache.sis.internal.util.AutoMessageFormat;
import org.apache.sis.internal.util.MetadataServices;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.RangeFormat;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.KeyConstants;
import org.apache.sis.util.resources.Loader;
import org.opengis.util.ControlledVocabulary;
import org.opengis.util.InternationalString;

public class IndexedResourceBundle
extends ResourceBundle
implements Localized {
    public static final Logger LOGGER = Logger.getLogger("org.apache.sis.util.resources");
    public static final String LOCALE_KEY = "locale";
    private static final int MAX_STRING_LENGTH = 200;
    static final int FIRST = 1;
    private URL resources;
    private volatile String[] values;
    private transient AutoMessageFormat format;
    private transient short lastKey;

    protected IndexedResourceBundle(URL resources) {
        this.resources = resources;
    }

    protected static <T extends IndexedResourceBundle> T getBundle(Class<T> base, Locale locale) throws MissingResourceException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return (T)((IndexedResourceBundle)base.cast(IndexedResourceBundle.getBundle(base.getName(), locale, base.getClassLoader(), Loader.INSTANCE)));
    }

    protected KeyConstants getKeyConstants() {
        Class keysClass = KeyConstants.class;
        for (Class<?> inner : this.getClass().getClasses()) {
            if (!"Keys".equals(inner.getSimpleName())) continue;
            keysClass = inner;
            break;
        }
        return new KeyConstants(keysClass);
    }

    @Override
    public final Enumeration<String> getKeys() {
        return new KeyEnum(this.getKeyConstants().getKeyNames());
    }

    public final void list(Appendable out) throws IOException {
        String[] keys;
        int keyLength = 0;
        for (String key : keys = this.getKeyConstants().getKeyNames()) {
            if (key == null) continue;
            keyLength = Math.max(keyLength, key.length());
        }
        String lineSeparator = System.lineSeparator();
        String[] values = this.ensureLoaded(null);
        for (int i = 0; i < values.length; ++i) {
            int indexLF;
            String key;
            key = keys[i];
            String value = values[i];
            if (key == null || value == null) continue;
            int indexCR = value.indexOf(13);
            if (indexCR < 0) {
                indexCR = value.length();
            }
            if ((indexLF = value.indexOf(10)) < 0) {
                indexLF = value.length();
            }
            String number = String.valueOf(i);
            out.append(CharSequences.spaces(5 - number.length())).append(number).append(": ").append(key).append(CharSequences.spaces(keyLength - key.length())).append(" = ").append(value, 0, Math.min(indexCR, indexLF)).append(lineSeparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] ensureLoaded(String key) throws MissingResourceException {
        String[] values = this.values;
        if (values == null) {
            IndexedResourceBundle indexedResourceBundle = this;
            synchronized (indexedResourceBundle) {
                values = this.values;
                if (values == null) {
                    if (this.resources == null) {
                        values = ((IndexedResourceBundle)this.parent).ensureLoaded(key);
                    } else {
                        Locale locale = this.getLocale();
                        String baseName = this.getClass().getCanonicalName();
                        String methodName = key != null ? "getObject" : "getKeys";
                        LogRecord record = new LogRecord(Level.FINER, "Loaded resources for {0} from bundle \"{1}\".");
                        try (DataInputStream input = new DataInputStream(new BufferedInputStream(this.resources.openStream()));){
                            values = new String[input.readInt()];
                            for (int i = 0; i < values.length; ++i) {
                                values[i] = input.readUTF();
                                if (!values[i].isEmpty()) continue;
                                values[i] = null;
                            }
                        }
                        catch (IOException exception) {
                            record.setLevel(Level.WARNING);
                            record.setMessage(exception.getMessage());
                            record.setThrown(exception);
                            Logging.completeAndLog(LOGGER, IndexedResourceBundle.class, methodName, record);
                            throw (MissingResourceException)new MissingResourceException(Exceptions.getLocalizedMessage(exception, locale), baseName, key).initCause(exception);
                        }
                        String language = null;
                        if (locale != null) {
                            language = locale.getDisplayName(Locale.US);
                        }
                        if (language == null || language.isEmpty()) {
                            language = "<root>";
                        }
                        record.setParameters(new String[]{language, baseName});
                        Logging.completeAndLog(LOGGER, IndexedResourceBundle.class, methodName, record);
                        this.resources = null;
                    }
                    this.values = values;
                }
            }
        }
        return values;
    }

    @Override
    protected final Object handleGetObject(String key) {
        int keyID;
        String[] values = this.ensureLoaded(key);
        try {
            keyID = Short.parseShort(key);
        }
        catch (NumberFormatException exception) {
            try {
                keyID = this.getKeyConstants().getKeyValue(key);
            }
            catch (ReflectiveOperationException e) {
                e.addSuppressed(exception);
                Logging.recoverableException(LOGGER, this.getClass(), "handleGetObject", e);
                return null;
            }
        }
        return --keyID >= 0 && keyID < values.length ? values[keyID] : null;
    }

    final Object[] toArray(Object arguments) {
        Object[] array = arguments instanceof Object[] ? (Object[])arguments : new Object[]{arguments};
        for (int i = 0; i < array.length; ++i) {
            Object element = array[i];
            if (element == null) continue;
            Object replacement = element;
            if (element instanceof CharSequence) {
                CharSequence text = (CharSequence)element;
                if (text instanceof InternationalString) {
                    text = ((InternationalString)element).toString(this.getLocale());
                }
                replacement = CharSequences.shortSentence(text, 200);
            } else if (element instanceof URI) {
                replacement = ((URI)element).getPath();
            } else if (element instanceof Class) {
                replacement = Classes.getShortName(IndexedResourceBundle.getPublicType((Class)element));
            } else if (element instanceof ControlledVocabulary) {
                replacement = MetadataServices.getInstance().getCodeTitle((ControlledVocabulary)element, this.getLocale());
            } else if (element instanceof Range) {
                Range range = (Range)element;
                replacement = new RangeFormat(this.getLocale(), range.getElementType()).format(range);
            } else if (element instanceof Unit) {
                String s = element.toString();
                if (s.isEmpty()) {
                    s = "1";
                }
                replacement = s;
            } else if (element.getClass().isArray()) {
                replacement = Utilities.deepToString(element);
            } else if (element instanceof Throwable) {
                String message = Exceptions.getLocalizedMessage((Throwable)element, this.getLocale());
                if (message == null) {
                    message = Classes.getShortClassName(element);
                }
                replacement = message;
            }
            if (replacement == element) continue;
            if (array == arguments) {
                array = Arrays.copyOf(array, array.length, Object[].class);
            }
            array[i] = replacement;
        }
        return array;
    }

    private static Class<?> getPublicType(Class<?> c) {
        while (!Modifier.isPublic(c.getModifiers())) {
            for (Class<?> type : c.getInterfaces()) {
                if (!Modifier.isPublic(type.getModifiers()) || type.getName().startsWith("java")) continue;
                return type;
            }
            c = c.getSuperclass();
        }
        return c;
    }

    public final void appendLabel(short key, Appendable toAppendTo) throws IOException {
        toAppendTo.append(this.getString(key));
        String colon = this.colon();
        if (colon != null) {
            toAppendTo.append(colon);
        } else {
            toAppendTo.append(':');
        }
    }

    public final String toLabel(String text) {
        return text.concat(this.colon());
    }

    public final String getLabel(short key) {
        String text = this.getString(key);
        String colon = this.colon();
        return colon != null ? text + colon : text + ":";
    }

    private String colon() {
        return Locale.FRENCH.getLanguage().equals(this.getLocale().getLanguage()) ? "\u00a0:" : null;
    }

    public final String getString(short key) throws MissingResourceException {
        return this.getString(String.valueOf(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getString(short key, Object arg0) throws MissingResourceException {
        String pattern = this.getString(key);
        Object[] arguments = this.toArray(arg0);
        IndexedResourceBundle indexedResourceBundle = this;
        synchronized (indexedResourceBundle) {
            if (this.format == null) {
                this.format = new AutoMessageFormat(pattern, this.getLocale());
                this.lastKey = key;
            } else if (key != this.lastKey) {
                this.format.applyPattern(pattern);
                this.lastKey = key;
            }
            try {
                this.format.configure(arguments);
                return this.format.format(arguments);
            }
            catch (RuntimeException e) {
                return "[Unformattable message: " + String.valueOf(e) + "]";
            }
        }
    }

    public final String getString(short key, Object arg0, Object arg1) throws MissingResourceException {
        return this.getString(key, new Object[]{arg0, arg1});
    }

    public final String getString(short key, Object arg0, Object arg1, Object arg2) throws MissingResourceException {
        return this.getString(key, new Object[]{arg0, arg1, arg2});
    }

    public final String getString(short key, Object arg0, Object arg1, Object arg2, Object arg3) throws MissingResourceException {
        return this.getString(key, new Object[]{arg0, arg1, arg2, arg3});
    }

    public final String getString(short key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) throws MissingResourceException {
        return this.getString(key, new Object[]{arg0, arg1, arg2, arg3, arg4});
    }

    public final LogRecord getLogRecord(Level level, short key) {
        LogRecord record = new LogRecord(level, this.getKeyConstants().getKeyName(key));
        record.setResourceBundleName(this.getClass().getName());
        record.setResourceBundle(this);
        return record;
    }

    public final LogRecord getLogRecord(Level level, short key, Object arg0) {
        LogRecord record = this.getLogRecord(level, key);
        record.setParameters(this.toArray(arg0));
        return record;
    }

    public final LogRecord getLogRecord(Level level, short key, Object arg0, Object arg1) {
        return this.getLogRecord(level, key, new Object[]{arg0, arg1});
    }

    public final LogRecord getLogRecord(Level level, short key, Object arg0, Object arg1, Object arg2) {
        return this.getLogRecord(level, key, new Object[]{arg0, arg1, arg2});
    }

    public final LogRecord getLogRecord(Level level, short key, Object arg0, Object arg1, Object arg2, Object arg3) {
        return this.getLogRecord(level, key, new Object[]{arg0, arg1, arg2, arg3});
    }

    protected static Locale getLocale(Map<?, ?> properties) {
        Object candidate;
        if (properties != null && (candidate = properties.get(LOCALE_KEY)) instanceof Locale) {
            return (Locale)candidate;
        }
        return null;
    }

    public synchronized String toString() {
        return Strings.bracket(this.getClass(), (Object)this.getLocale());
    }

    private static final class KeyEnum
    implements Enumeration<String> {
        private final String[] keys;
        private int next;

        KeyEnum(String[] keys) {
            this.keys = keys;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.next < this.keys.length) {
                if (this.keys[this.next] != null) {
                    return true;
                }
                ++this.next;
            }
            return false;
        }

        @Override
        public String nextElement() {
            while (this.next < this.keys.length) {
                String key;
                if ((key = this.keys[this.next++]) == null) continue;
                return key;
            }
            throw new NoSuchElementException();
        }
    }
}

