/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.filter;

import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import org.opengis.filter.Expression;
import org.opengis.filter.Filter;
import org.opengis.filter.InvalidFilterValueException;
import org.opengis.filter.Name;
import org.opengis.util.CodeList;
import org.opengis.util.ScopedName;

final class FilterExpressions<R>
extends AbstractList<Expression<R, ?>> {
    private final List<Filter<R>> filters;

    FilterExpressions(List<Filter<R>> list) {
        this.filters = Objects.requireNonNull(list);
    }

    @Override
    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    @Override
    public int size() {
        return this.filters.size();
    }

    @Override
    public Expression<R, ?> get(int n) {
        return new Element<R>(this.filters.get(n));
    }

    private static final class Element<R>
    implements Expression<R, Boolean> {
        private final Filter<R> filter;

        Element(Filter<R> filter) {
            this.filter = Objects.requireNonNull(filter);
        }

        @Override
        public ScopedName getFunctionName() {
            CodeList<?> codeList = this.filter.getOperatorType();
            String string = codeList.identifier();
            if (string != null) {
                return new Name(Name.STANDARD, string);
            }
            return new Name(Name.EXTENSION, codeList.name());
        }

        @Override
        public Class<? super R> getResourceClass() {
            return this.filter.getResourceClass();
        }

        @Override
        public List<Expression<R, ?>> getParameters() {
            return this.filter.getExpressions();
        }

        @Override
        public Boolean apply(R r) throws InvalidFilterValueException {
            return this.filter.test(r);
        }

        @Override
        public <N> Expression<R, N> toValueType(Class<N> clazz) {
            if (clazz.isAssignableFrom(Boolean.class)) {
                return this;
            }
            throw new ClassCastException();
        }

        public int hashCode() {
            return ~this.filter.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof Element && this.filter.equals(((Element)object).filter);
        }

        public String toString() {
            return "Expression[" + this.filter.toString() + "]";
        }
    }
}

