/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata.content;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.content.AttributeGroup;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.content.RangeDimension;
import org.opengis.metadata.content.RangeElementDescription;
import org.opengis.util.RecordType;

@UML(identifier="MD_CoverageDescription", specification=Specification.ISO_19115)
public interface CoverageDescription
extends ContentInformation {
    @UML(identifier="attributeDescription", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public RecordType getAttributeDescription();

    @UML(identifier="processingLevelCode", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Identifier getProcessingLevelCode() {
        return null;
    }

    @UML(identifier="attributeGroup", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends AttributeGroup> getAttributeGroups() {
        return Collections.emptyList();
    }

    @Deprecated
    @UML(identifier="contentType", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115, version=2003)
    default public CoverageContentType getContentType() {
        for (AttributeGroup attributeGroup : this.getAttributeGroups()) {
            Iterator<CoverageContentType> iterator = attributeGroup.getContentTypes().iterator();
            if (!iterator.hasNext()) continue;
            return iterator.next();
        }
        return null;
    }

    @Deprecated
    @UML(identifier="dimension", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public Collection<? extends RangeDimension> getDimensions() {
        return Collections.emptyList();
    }

    @UML(identifier="rangeElementDescription", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115_2)
    default public Collection<? extends RangeElementDescription> getRangeElementDescriptions() {
        return Collections.emptyList();
    }
}

