/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata.quality;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.CodeList;

@UML(identifier="DQM_ValueStructure", specification=Specification.ISO_19157)
public final class ValueStructure
extends CodeList<ValueStructure> {
    private static final long serialVersionUID = 455647811714853262L;
    private static final List<ValueStructure> VALUES = new ArrayList<ValueStructure>(6);
    @UML(identifier="bag", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19157)
    public static final ValueStructure BAG = new ValueStructure("BAG", Collection.class);
    @UML(identifier="set", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19157)
    public static final ValueStructure SET = new ValueStructure("SET", Set.class);
    @UML(identifier="sequence", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19157)
    public static final ValueStructure SEQUENCE = new ValueStructure("SEQUENCE", List.class);
    @UML(identifier="table", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19157)
    public static final ValueStructure TABLE = new ValueStructure("TABLE", Map.class);
    @UML(identifier="matrix", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19157)
    public static final ValueStructure MATRIX = new ValueStructure("MATRIX", Matrix.class);
    @UML(identifier="coverage", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19157)
    public static final ValueStructure COVERAGE = new ValueStructure("COVERAGE");
    private static final ValueStructure[] PREDEFINED = new ValueStructure[]{SEQUENCE, SET, TABLE, BAG, MATRIX};
    private final Class<?> type;

    private ValueStructure(String string) {
        super(string, VALUES);
        this.type = null;
    }

    private ValueStructure(String string, Class<?> clazz) {
        super(string, VALUES);
        this.type = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValueStructure[] values() {
        List<ValueStructure> list = VALUES;
        synchronized (list) {
            return (ValueStructure[])VALUES.toArray(ValueStructure[]::new);
        }
    }

    public ValueStructure[] family() {
        return ValueStructure.values();
    }

    public static ValueStructure valueOf(String string) {
        return ValueStructure.valueOf(ValueStructure.class, string);
    }

    public static Optional<ValueStructure> valueOf(Class<?> clazz) {
        if (clazz != null) {
            for (ValueStructure valueStructure : PREDEFINED) {
                if (!valueStructure.type.isAssignableFrom(clazz)) continue;
                return Optional.of(valueStructure);
            }
        }
        return Optional.empty();
    }

    public Optional<Class<?>> toJavaType() {
        return Optional.ofNullable(this.type);
    }
}

