/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.io.Serializable;
import java.sql.Time;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.apache.sis.util.SimpleInternationalString;
import org.geotoolkit.gml.xml.AbstractTimePosition;
import org.geotoolkit.gml.xml.TimeIndeterminateValueType;
import org.geotoolkit.temporal.object.TemporalUtilities;
import org.opengis.util.InternationalString;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="TimePositionType", propOrder={"value"})
public class TimePositionType
extends AbstractTimePosition
implements Serializable {
    private String value;
    @XmlAttribute
    @XmlSchemaType(name="anyURI")
    private String frame;
    @XmlAttribute
    private String calendarEraName;
    @XmlAttribute
    private TimeIndeterminateValueType indeterminatePosition;
    @XmlTransient
    private Date cachedDate;

    public TimePositionType() {
    }

    public TimePositionType(String value) {
        this.value = value;
    }

    public TimePositionType(AbstractTimePosition value) {
        this(value.getDate());
        this.indeterminatePosition = value.getIndeterminatePosition();
    }

    public TimePositionType(TimeIndeterminateValueType indeterminatePosition) {
        this.indeterminatePosition = indeterminatePosition;
        this.value = "";
    }

    public TimePositionType(Date time) {
        this.setValue(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XmlValue
    public String getValue() {
        if (this.cachedDate != null && this.value == null) {
            DateFormat df;
            Calendar c = Calendar.getInstance();
            c.setTime(this.cachedDate);
            if (c.get(10) == 0 && c.get(12) == 0 && c.get(13) == 0) {
                DateFormat df2;
                DateFormat dateFormat = df2 = (DateFormat)FORMATTERS.get(3);
                synchronized (dateFormat) {
                    this.value = df2.format(this.cachedDate);
                }
            }
            DateFormat dateFormat = df = (DateFormat)FORMATTERS.get(0);
            synchronized (dateFormat) {
                this.value = df.format(this.cachedDate);
            }
        }
        return this.value;
    }

    public void setValue(String value) {
        this.cachedDate = null;
        this.value = value;
    }

    public final void setValue(Date value) {
        this.cachedDate = value;
        this.value = null;
    }

    public String getFrame() {
        return this.frame;
    }

    public void setFrame(String value) {
        this.frame = value;
    }

    public String getCalendarEraName() {
        return this.calendarEraName;
    }

    public void setCalendarEraName(String value) {
        this.calendarEraName = value;
    }

    @Override
    public TimeIndeterminateValueType getIndeterminatePosition() {
        return this.indeterminatePosition;
    }

    public void setIndeterminatePosition(TimeIndeterminateValueType value) {
        this.indeterminatePosition = value;
    }

    @Override
    public Date getDate() {
        if (this.cachedDate == null && this.value != null && !this.value.isEmpty()) {
            this.cachedDate = this.parseDate(this.value);
        }
        return this.cachedDate;
    }

    public Time getTime() {
        String v = this.getValue();
        if (v != null) {
            return Time.valueOf(v);
        }
        return null;
    }

    public InternationalString getDateTime() {
        String v = this.getValue();
        if (v != null) {
            return new SimpleInternationalString(v);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TimePositionType) {
            TimePositionType that = (TimePositionType)object;
            return Objects.equals(this.calendarEraName, that.calendarEraName) && Objects.equals(this.frame, that.frame) && Objects.equals((Object)this.indeterminatePosition, (Object)that.indeterminatePosition) && (Objects.equals(this.value, that.value) || TemporalUtilities.dateEquals((Date)this.getDate(), (Date)that.getDate()));
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 97 * hash + (this.calendarEraName != null ? this.calendarEraName.hashCode() : 0);
        hash = 97 * hash + (this.frame != null ? this.frame.hashCode() : 0);
        hash = 97 * hash + (this.indeterminatePosition != null ? this.indeterminatePosition.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.calendarEraName != null) {
            s.append("calendarEraName:").append(this.calendarEraName).append('\n');
        }
        if (this.frame != null) {
            s.append("frame:").append(this.frame).append('\n');
        }
        if (this.indeterminatePosition != null) {
            s.append("indeterminatePosition:").append(this.indeterminatePosition.value()).append('\n');
        }
        if (this.value != null && this.getDate() != null) {
            s.append("value=").append(this.value).append('\n');
        }
        return s.toString();
    }
}

