/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.sis.internal.referencing.LazySet;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeProviderPair;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;

final class DataStoreRegistry {
    private final ServiceLoader<DataStoreProvider> loader;

    public DataStoreRegistry() {
        this.loader = DefaultFactories.createServiceLoader(DataStoreProvider.class);
    }

    public DataStoreRegistry(ClassLoader loader) {
        ArgumentChecks.ensureNonNull("loader", loader);
        this.loader = ServiceLoader.load(DataStoreProvider.class, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DataStoreProvider> providers() {
        ServiceLoader<DataStoreProvider> serviceLoader = this.loader;
        synchronized (serviceLoader) {
            final Iterator<DataStoreProvider> providers = this.loader.iterator();
            return new LazySet((Iterator)new Iterator<DataStoreProvider>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean hasNext() {
                    ServiceLoader<DataStoreProvider> serviceLoader = DataStoreRegistry.this.loader;
                    synchronized (serviceLoader) {
                        return providers.hasNext();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public DataStoreProvider next() {
                    ServiceLoader<DataStoreProvider> serviceLoader = DataStoreRegistry.this.loader;
                    synchronized (serviceLoader) {
                        return (DataStoreProvider)providers.next();
                    }
                }
            });
        }
    }

    public String probeContentType(Object storage) throws DataStoreException {
        ArgumentChecks.ensureNonNull("storage", storage);
        ProbeProviderPair p = this.lookup(storage, false);
        return p != null ? p.probe.getMimeType() : null;
    }

    public DataStore open(Object storage) throws UnsupportedStorageException, DataStoreException {
        ArgumentChecks.ensureNonNull("storage", storage);
        return this.lookup((Object)storage, (boolean)true).store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProbeProviderPair lookup(Object storage, boolean open) throws DataStoreException {
        StorageConnector connector = storage instanceof StorageConnector ? (StorageConnector)storage : new StorageConnector(storage);
        String extension = connector.getFileExtension();
        boolean useSuffix = extension != null && !extension.isEmpty();
        Category[] categories = Category.values(useSuffix);
        ProbeProviderPair selected = null;
        LinkedList<ProbeProviderPair> needMoreBytes = new LinkedList<ProbeProviderPair>();
        try {
            block9: for (int ci = 0; ci < categories.length; ++ci) {
                DataStoreProvider provider;
                Iterator<DataStoreProvider> providers;
                Category category = categories[ci];
                ServiceLoader<DataStoreProvider> serviceLoader = this.loader;
                synchronized (serviceLoader) {
                    providers = this.loader.iterator();
                    provider = providers.hasNext() ? providers.next() : null;
                }
                while (provider != null) {
                    boolean accept;
                    StoreMetadata md = provider.getClass().getAnnotation(StoreMetadata.class);
                    if (md == null) {
                        accept = ci == 0;
                    } else {
                        boolean bl = accept = md.yieldPriority() == category.yieldPriority;
                        if (accept & useSuffix) {
                            boolean bl2 = accept = ArraysExt.containsIgnoreCase(md.fileSuffixes(), extension) == category.useSuffix;
                        }
                    }
                    if (accept) {
                        ProbeResult probe = provider.probeContent(connector);
                        if (probe.isSupported()) {
                            selected = new ProbeProviderPair(provider, probe);
                            break block9;
                        }
                        if (ProbeResult.INSUFFICIENT_BYTES.equals(probe)) {
                            needMoreBytes.add(new ProbeProviderPair(provider, probe));
                        } else if (ProbeResult.UNDETERMINED.equals(probe) && selected == null) {
                            selected = new ProbeProviderPair(provider, probe);
                        }
                    }
                    ServiceLoader<DataStoreProvider> serviceLoader2 = this.loader;
                    synchronized (serviceLoader2) {
                        provider = providers.hasNext() ? providers.next() : null;
                    }
                }
                while (!needMoreBytes.isEmpty() && connector.prefetch()) {
                    Iterator it = needMoreBytes.iterator();
                    while (it.hasNext()) {
                        ProbeProviderPair p = (ProbeProviderPair)it.next();
                        p.probe = p.provider.probeContent(connector);
                        if (p.probe.isSupported()) {
                            selected = p;
                            break block9;
                        }
                        if (ProbeResult.INSUFFICIENT_BYTES.equals(p.probe)) continue;
                        if (selected == null && ProbeResult.UNDETERMINED.equals(p.probe)) {
                            selected = p;
                        }
                        it.remove();
                    }
                }
            }
            if (open && selected != null) {
                selected.store = selected.provider.open(connector);
                connector = null;
            }
        }
        finally {
            if (connector != null && connector != storage) {
                connector.closeAllExcept(null);
            }
        }
        if (open && selected == null) {
            String name = connector.getStorageName();
            throw new UnsupportedStorageException(null, 14, name);
        }
        return selected;
    }

    private static enum Category {
        SUFFIX_MATCH(true, false),
        IGNORE_SUFFIX(false, false),
        DEFERRED(true, true),
        DEFERRED_IGNORE_SUFFIX(false, true);

        final boolean useSuffix;
        final boolean yieldPriority;

        private Category(boolean useSuffix, boolean yieldPriority) {
            this.useSuffix = useSuffix;
            this.yieldPriority = yieldPriority;
        }

        static Category[] values(boolean useSuffix) {
            Category[] categoryArray;
            if (useSuffix) {
                categoryArray = Category.values();
            } else {
                Category[] categoryArray2 = new Category[2];
                categoryArray2[0] = IGNORE_SUFFIX;
                categoryArray = categoryArray2;
                categoryArray2[1] = DEFERRED_IGNORE_SUFFIX;
            }
            return categoryArray;
        }
    }
}

