/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.boot.es.ik.redict.dictionary;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.TransactionResult;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.Objects;
import org.openingo.boot.es.ik.redict.configuration.RemoteDictionaryConfigurationProperties;
import org.openingo.boot.es.ik.redict.dictionary.AbstractRemoteDictionary;
import org.openingo.boot.es.ik.redict.dictionary.DictionaryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisRemoteDictionary
extends AbstractRemoteDictionary {
    private static final Logger log = LoggerFactory.getLogger(RedisRemoteDictionary.class);
    private final StatefulRedisConnection<String, String> redisConnection = this.getRedisConnection();
    private static final String KEY_PREFIX = "es-ik-words";

    public RedisRemoteDictionary(RemoteDictionaryConfigurationProperties properties) {
        super(properties);
    }

    @Override
    protected boolean addWord(String domain, DictionaryType dictionaryType, String word) {
        log.info("'{}' remote dictionary add new word '{}' for dictionary '{}'", new Object[]{this.etymology(), word, dictionaryType});
        RedisCommands sync = this.redisConnection.sync();
        sync.multi();
        String key = this.getKey(dictionaryType, domain);
        sync.lpush((Object)key, (Object[])new String[]{word});
        String state = String.format("%s:state", key);
        sync.set((Object)state, (Object)"true");
        TransactionResult transactionResult = sync.exec();
        for (Object txRet : transactionResult) {
            log.info("txRet '{}'", txRet);
        }
        log.info("'{} add new word '{}' success.", (Object)this.etymology(), (Object)word);
        return true;
    }

    @Override
    protected void closeResource() {
        String etymology = this.etymology();
        log.info("'{}' remote dictionary is closing...", (Object)etymology);
        this.redisConnection.close();
        log.info("'{}' remote dictionary is closed", (Object)etymology);
    }

    @Override
    protected String etymology() {
        return "redis";
    }

    private String getKey(DictionaryType dictionaryType, String domain) {
        return String.format("%s:%s:%s", KEY_PREFIX, domain, dictionaryType.getDictName());
    }

    private StatefulRedisConnection<String, String> getRedisConnection() {
        RemoteDictionaryConfigurationProperties.Redis redis = this.properties.getRedis();
        RedisURI.Builder builder = RedisURI.builder().withHost(redis.getHost()).withPort(redis.getPort().intValue()).withDatabase(redis.getDatabase().intValue());
        String username = redis.getUsername();
        String password = redis.getPassword();
        if (Objects.nonNull(username) && Objects.nonNull(password)) {
            builder.withAuthentication(redis.getUsername(), password.toCharArray());
        } else if (Objects.nonNull(password)) {
            builder.withPassword(password.toCharArray());
        }
        return RedisClient.create((RedisURI)builder.build()).connect();
    }
}

