/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.boot.morphia.configuration;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import org.openingo.boot.morphia.configuration.MorphiaConfigurationProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MorphiaConfigurationProperties.class})
public class MorphiaAutoConfiguration {
    private final MorphiaConfigurationProperties properties;

    public MorphiaAutoConfiguration(MorphiaConfigurationProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={Datastore.class})
    public Datastore datastore() {
        MongoClient mongoClient;
        Morphia morphia = new Morphia();
        if (this.properties.getMapPackage() != null) {
            morphia.mapPackage(this.properties.getMapPackage());
        }
        MongoClientOptions options = new MongoClientOptions.Builder().build();
        if (this.properties.getUsername() != null && this.properties.getPassword() != null) {
            MongoCredential credential = MongoCredential.createCredential((String)this.properties.getUsername(), (String)this.properties.getAuthDatabase(), (char[])this.properties.getPassword().toCharArray());
            mongoClient = new MongoClient(new ServerAddress(this.properties.getHost(), this.properties.getPort().intValue()), credential, options);
        } else {
            mongoClient = new MongoClient(new ServerAddress(this.properties.getHost(), this.properties.getPort().intValue()));
        }
        Datastore datastore = morphia.createDatastore(mongoClient, this.properties.getDatabase());
        datastore.ensureIndexes();
        return datastore;
    }
}

