/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.data.elasticsearch.builder.index;

import java.util.HashMap;

public final class MappingsProperty
extends HashMap<String, Object> {
    private String name;

    private MappingsProperty() {
    }

    public static MappingsProperty me() {
        return new MappingsProperty().keyword();
    }

    public static MappingsProperty me(String name) {
        return MappingsProperty.me().name(name);
    }

    public MappingsProperty name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public MappingsProperty type(String type) {
        return this.add("type", type);
    }

    public MappingsProperty textType() {
        return this.type("text");
    }

    public MappingsProperty analyzer(String analyzer) {
        return this.add("analyzer", analyzer);
    }

    public MappingsProperty searchAnalyzer(String searchAnalyzer) {
        return this.add("search_analyzer", searchAnalyzer);
    }

    public MappingsProperty format(String format) {
        return this.add("format", format);
    }

    public MappingsProperty store(boolean store) {
        return this.add("store", store);
    }

    public MappingsProperty fielddata(boolean fielddata) {
        return this.add("fielddata", fielddata);
    }

    public MappingsProperty normalizer(String normalizer) {
        return this.add("normalizer", normalizer);
    }

    public MappingsProperty keyword() {
        return this.keyword(256);
    }

    public MappingsProperty keyword0() {
        return this.keyword(0);
    }

    public MappingsProperty keyword(int ignoreAbove) {
        MappingsProperty keyword = new MappingsProperty().type("keyword");
        if (ignoreAbove != 0) {
            keyword.add("ignore_above", ignoreAbove);
        }
        return this.add("fields", new MappingsProperty().add("keyword", keyword));
    }

    public MappingsProperty add(String key, Object value) {
        this.put(key, value);
        return this;
    }
}

