/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.helper;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class BeanAccessor
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private final ConcurrentHashMap<Class<?>, Object> beans = new ConcurrentHashMap();

    public void setApplicationContext(@Nullable ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public <T> T bean(Class<T> clazz) {
        Object o = this.beans.get(clazz);
        if (Objects.isNull(o)) {
            o = this.applicationContext.getBean(clazz);
            this.beans.put(clazz, o);
        }
        return (T)o;
    }

    public <T> T prototypeBean(Class<T> clazz) {
        return (T)this.applicationContext.getBean(clazz);
    }
}

