/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import javax.websocket.EncodeException;
import javax.websocket.SendHandler;
import org.openingo.jdkits.json.JacksonKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.boot.extension.websocket.WebsocketServerEndpoint;

public class InstantManager {
    private ConcurrentHashMap<Integer, List<WebsocketServerEndpoint>> connections = new ConcurrentHashMap();
    static InstantManager manager = new InstantManager();

    private InstantManager() {
    }

    void addConnection(Integer connId, WebsocketServerEndpoint endpoint) {
        this.listEndpoint(connId).add(endpoint);
    }

    void removeConnection(Integer connId, WebsocketServerEndpoint endpoint) {
        this.listEndpoint(connId).remove(endpoint);
    }

    List<WebsocketServerEndpoint> listEndpoint(Integer connId) {
        List<WebsocketServerEndpoint> oldEndpointList;
        List<WebsocketServerEndpoint> endpointList = this.connections.get(connId);
        if (ValidateKit.isNull(endpointList) && ValidateKit.isNotNull(oldEndpointList = this.connections.putIfAbsent(connId, endpointList = new CopyOnWriteArrayList<WebsocketServerEndpoint>()))) {
            endpointList = oldEndpointList;
        }
        return endpointList;
    }

    public static void sendText(Integer connId, String text) throws IOException {
        List<WebsocketServerEndpoint> websocketServerEndpoints = manager.listEndpoint(connId);
        for (WebsocketServerEndpoint websocketServerEndpoint : websocketServerEndpoints) {
            websocketServerEndpoint.getBasicRemote().sendText(text);
        }
    }

    public static void sendBinary(Integer connId, ByteBuffer data) throws IOException {
        List<WebsocketServerEndpoint> websocketServerEndpoints = manager.listEndpoint(connId);
        for (WebsocketServerEndpoint websocketServerEndpoint : websocketServerEndpoints) {
            websocketServerEndpoint.getBasicRemote().sendBinary(data);
        }
    }

    public static void sendText(Integer connId, String fragment, boolean isLast) throws IOException {
        List<WebsocketServerEndpoint> websocketServerEndpoints = manager.listEndpoint(connId);
        for (WebsocketServerEndpoint websocketServerEndpoint : websocketServerEndpoints) {
            websocketServerEndpoint.getBasicRemote().sendText(fragment, isLast);
        }
    }

    public void sendBinary(Integer connId, ByteBuffer partialByte, boolean isLast) throws IOException {
        List<WebsocketServerEndpoint> websocketServerEndpoints = manager.listEndpoint(connId);
        for (WebsocketServerEndpoint websocketServerEndpoint : websocketServerEndpoints) {
            websocketServerEndpoint.getBasicRemote().sendBinary(partialByte, isLast);
        }
    }

    public void sendObject(Integer connId, Object data) throws IOException, EncodeException {
        List<WebsocketServerEndpoint> websocketServerEndpoints = manager.listEndpoint(connId);
        for (WebsocketServerEndpoint websocketServerEndpoint : websocketServerEndpoints) {
            websocketServerEndpoint.getBasicRemote().sendObject(data);
        }
    }

    public static long getSessionAsyncSendTimeout(Integer connId) {
        List<WebsocketServerEndpoint> websocketServerEndpoints = manager.listEndpoint(connId);
        if (ValidateKit.isNotNull(websocketServerEndpoints)) {
            return websocketServerEndpoints.get(0).getAsyncRemote().getSendTimeout();
        }
        return -1L;
    }

    public static void setAsyncSendTimeout(Integer connId, long timeout) {
        List<WebsocketServerEndpoint> websocketServerEndpoints = manager.listEndpoint(connId);
        for (WebsocketServerEndpoint websocketServerEndpoint : websocketServerEndpoints) {
            websocketServerEndpoint.getAsyncRemote().setSendTimeout(timeout);
        }
    }

    public void asyncSendText(Integer connId, String text, SendHandler completion) {
        List<WebsocketServerEndpoint> websocketServerEndpoints = manager.listEndpoint(connId);
        for (WebsocketServerEndpoint websocketServerEndpoint : websocketServerEndpoints) {
            websocketServerEndpoint.getAsyncRemote().sendText(text, completion);
        }
    }

    public static List<Future<Void>> asyncSendText(Integer connId, String text) {
        List<WebsocketServerEndpoint> websocketServerEndpoints = manager.listEndpoint(connId);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(websocketServerEndpoints.size());
        for (WebsocketServerEndpoint websocketServerEndpoint : websocketServerEndpoints) {
            futures.add(websocketServerEndpoint.getAsyncRemote().sendText(text));
        }
        return futures;
    }

    public static List<Future<Void>> asyncSendBinary(Integer connId, ByteBuffer data) {
        List<WebsocketServerEndpoint> websocketServerEndpoints = manager.listEndpoint(connId);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(websocketServerEndpoints.size());
        for (WebsocketServerEndpoint websocketServerEndpoint : websocketServerEndpoints) {
            futures.add(websocketServerEndpoint.getAsyncRemote().sendBinary(data));
        }
        return futures;
    }

    public static void asyncSendBinary(Integer connId, ByteBuffer data, SendHandler completion) {
        List<WebsocketServerEndpoint> websocketServerEndpoints = manager.listEndpoint(connId);
        for (WebsocketServerEndpoint websocketServerEndpoint : websocketServerEndpoints) {
            websocketServerEndpoint.getAsyncRemote().sendBinary(data, completion);
        }
    }

    public static List<Future<Void>> asyncSendObject(Integer connId, Object obj) {
        List<WebsocketServerEndpoint> websocketServerEndpoints = manager.listEndpoint(connId);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(websocketServerEndpoints.size());
        for (WebsocketServerEndpoint websocketServerEndpoint : websocketServerEndpoints) {
            futures.add(websocketServerEndpoint.getAsyncRemote().sendObject(obj));
        }
        return futures;
    }

    public static void asyncSendObject(Integer connId, Object obj, SendHandler completion) {
        List<WebsocketServerEndpoint> websocketServerEndpoints = manager.listEndpoint(connId);
        for (WebsocketServerEndpoint websocketServerEndpoint : websocketServerEndpoints) {
            websocketServerEndpoint.getAsyncRemote().sendObject(obj, completion);
        }
    }

    public static void sendJson(Integer connId, Object obj) throws IOException {
        List<WebsocketServerEndpoint> websocketServerEndpoints = manager.listEndpoint(connId);
        for (WebsocketServerEndpoint websocketServerEndpoint : websocketServerEndpoints) {
            websocketServerEndpoint.getBasicRemote().sendText(JacksonKit.toJson((Object)obj));
        }
    }

    public static void asyncSendJson(Integer connId, Object obj) throws IOException {
        List<WebsocketServerEndpoint> websocketServerEndpoints = manager.listEndpoint(connId);
        for (WebsocketServerEndpoint websocketServerEndpoint : websocketServerEndpoints) {
            websocketServerEndpoint.getAsyncRemote().sendText(JacksonKit.toJson((Object)obj));
        }
    }

    static InstantManager getInstance() {
        return manager;
    }
}

