/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.mq.rocket;

import javax.annotation.Resource;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProducer<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractProducer.class);
    @Resource
    protected RocketMQTemplate rocketMqTemplate;

    public boolean syncSend(String topic, T payload) {
        return this.send(topic, payload);
    }

    public boolean syncSend(String topic, String tags, T payload) {
        return this.send(String.format("%s:%s", topic, tags), payload);
    }

    public void asyncSend(String topic, T payload, SendCallback sendCallback) {
        this.send(topic, payload, sendCallback);
    }

    public void asyncSend(String topic, String tags, T payload, SendCallback sendCallback) {
        this.send(String.format("%s:%s", topic, tags), payload, sendCallback);
    }

    private boolean send(String destination, T payload) {
        log.info("sync send destination {} payload {}", (Object)destination, payload);
        SendResult sendResult = this.rocketMqTemplate.syncSend(destination, payload);
        boolean ret = SendStatus.SEND_OK.equals((Object)sendResult.getSendStatus());
        log.info("send data to rocketMQ result {} {}!", (Object)sendResult, (Object)(ret ? "success" : "failed"));
        return ret;
    }

    private void send(String destination, T payload, SendCallback sendCallback) {
        log.info("async send destination {} payload {}", (Object)destination, payload);
        this.rocketMqTemplate.asyncSend(destination, payload, sendCallback);
    }
}

