/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.distributedlock.config;

import java.util.concurrent.locks.ReentrantLock;
import org.openingo.spring.boot.extension.distributedlock.lock.DistributedLockPingPong;
import org.openingo.spring.boot.extension.distributedlock.store.DistributedLockStore;
import org.openingo.spring.boot.extension.gedid.config.RedisConnectionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@ConditionalOnClass(value={RedisTemplate.class, RedisOperations.class})
public class DistributedLockConfig {
    private static final Logger log = LoggerFactory.getLogger(DistributedLockConfig.class);
    private ReentrantLock pingPongLock = new ReentrantLock();
    private boolean pingPongStarted = false;
    public static final Integer EXPIRE_SECONDS = 180000;
    public static final int MAX_TRYING_TIME_MILLIS = 300000;

    DistributedLockConfig(RedisConnectionConfiguration configuration) {
        this.start(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(RedisConnectionConfiguration configuration) {
        this.pingPongLock.lock();
        try {
            if (this.pingPongStarted) {
                return;
            }
            StringRedisTemplate template = new StringRedisTemplate();
            template.setConnectionFactory(configuration.redisConnectionFactory());
            template.afterPropertiesSet();
            DistributedLockStore lockStore = new DistributedLockStore(template);
            DistributedLockPingPong.start(lockStore);
            this.pingPongStarted = true;
        }
        finally {
            this.pingPongLock.unlock();
        }
    }
}

